/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef DEFLECTIONSIMULATORHEADERFILE
#define DEFLECTIONSIMULATORHEADERFILE

#include <QMainWindow>
#include <vector>

#include "measurementdata.h"

class QLabel;
class QLineEdit;
class QSlider;
class QComboBox;
class QSettings;
class QCloseEvent;
class QAction;
class QListWidget;
class QToolButton;
class TDisplayWidget;
class TMeasurementEditWidget;
class TMessageBox;

class TDeflectionSimulator : public QMainWindow
{
Q_OBJECT

public:

// CREATORS
	TDeflectionSimulator(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TDeflectionSimulator(void);

// ACCESSORS

// MANIPULATORS

signals:

private slots:
	
	void Deflection_Model_Changed(int);

	void Parameter1_Changed(const QString&);
	void Parameter2_Changed(const QString&);
	void Parameter3_Changed(const QString&);
	void Parameter4_Changed(const QString&);
	void Range_Y_Changed(const QString&);
	void Range_Z_Changed(const QString&);
	void Exaggeration_Changed(int);
	
	void Add_Measurement(void);
	void Remove_Measurements(void);
	void Measurement_Selection_Changed(void);
	void Measurement_Data_Changed(void);
	
	void Menu_New(void);
	void Menu_Init(void);
	void Menu_About(void);

	
protected:
	virtual void closeEvent(QCloseEvent *event);

private:
	QAction								*d_action_new;
	QAction								*d_action_init;
	QAction								*d_action_quit;
	QAction								*d_action_about;
	QListWidget							*d_measurement_list;
	TMeasurementEditWidget				*d_measurement_edit_widget;
	QToolButton							*d_add_measurement_button;
	QToolButton							*d_remove_measurement_button;
	TDisplayWidget						*d_display_widget;
	QComboBox							*d_deflection_model_type_combo;
	QLineEdit							*d_range_y_edit;
	QLineEdit							*d_range_z_edit;
	QLabel								*d_parameter1_label;
	QLineEdit							*d_parameter1_edit;
	QLabel								*d_parameter1_units_label;
	QLabel								*d_parameter2_label;
	QLineEdit							*d_parameter2_edit;
	QLabel								*d_parameter2_units_label;
	QLabel								*d_parameter3_label;
	QLineEdit							*d_parameter3_edit;
	QLabel								*d_parameter3_units_label;
	QLabel								*d_parameter4_label;
	QLineEdit							*d_parameter4_edit;
	QLabel								*d_parameter4_units_label;
	QSlider								*d_exaggeration_slider;
	QSettings							*d_settings;
	TMessageBox							*d_msg_box;
	QString								d_data_path;
	
	TMeasurementData					d_measurement_data;
	
	void Update_Actual_Length(void);

	
// NOT IMPLEMENTED
	TDeflectionSimulator(const TDeflectionSimulator&);
	TDeflectionSimulator& operator=(const TDeflectionSimulator&);
};

#endif
