/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include "lkdeflectionmodel.h"

TLKDeflectionModel::TLKDeflectionModel(void)
{
}

TLKDeflectionModel::~TLKDeflectionModel(void)
{
}

TVector3 TLKDeflectionModel::Calculate_Correction(
	const TVector3						&pos) const
{
	double								ryx;
	double								tzy;
	double								pos_y(pos.y / 1000.0);	// length in meters
	double								pos_z(pos.z / 1000.0);	// length in meters
	TVector3							correction;
	
	ryx = this->Rotation_YX(pos_y,pos_z);		// angle in radians
	tzy = this->Translation_Y(pos_y,pos_z);
	
	correction.y = 10.0 * (0.0 - sin(ryx) * pos_z);		// change in Y axis from Z pos
	correction.z = 10.0 * (sin(ryx) * pos_y);			// change in Z axis from Y pos
	
	correction.y += tzy;						// change in Y axis
	
	return correction;
}

double TLKDeflectionModel::Rotation_YX(
	const double 						&pos_y,
	const double 						&pos_z) const
{
	double								result;
	double								factor_z;
	static const double					ARCSEC_TO_RADIANS(0.4848136811076367);
	
	factor_z = pos_z * d_parameter4 * 1000.0;

	result = d_parameter3 * pos_y * ARCSEC_TO_RADIANS;
	result *= factor_z;
		
	return result;
}

double TLKDeflectionModel::Translation_Y(
	const double 						&pos_y,
	const double 						&pos_z) const
{
	double								result;
	double								factor_z;
	
	factor_z = pos_z * d_parameter2 * 1000.0; // / (d_range_z / 1000);
	result = d_parameter1 * pos_y * factor_z * 1000.0;
	
	return result;
}

