/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef MEASUREMENTDATAHEADERFILE
#define MEASUREMENTDATAHEADERFILE

#include <QString>
#include <vector>

#include "../../core/vector3.h"

class TXmlFile;

class TMeasurementData
{
public:
	
struct TMeasurement
{
	int									id;
	TVector3							pos;
	TVector3							vec;
	double								nominal_length;
};
	
// CREATORS
	TMeasurementData(void);
	~TMeasurementData(void);
	
// ACCESSORS
	QString Last_Error(void) const {return d_last_error;}
		
	bool Get_Measurement(const int id,TMeasurement * const measurement) const;
	std::vector<int> Get_Measurement_Ids(void) const;
	
	bool Save_Data(const QString &file_name) const;
	
// MANIPULATORS
	bool Load_Data(const QString &file_name);
	
	int Add_Measurement(void);
	bool Update_Measurement(const TMeasurement &measurement);
	bool Remove_Measurement(const int id);
	void Clear_Measurements(void);
	
private:
	
	std::vector<TMeasurement>			d_data;
	
	mutable QString						d_last_error;
	
	void Load_Data_V1(TXmlFile * const xml_file);
	void Add_Measurement(const TMeasurement &measurement);
	
	bool Measurement_Id_Exists(const int id) const;
	
// NOT IMPLEMENTED
	TMeasurementData(const TMeasurementData&);
	TMeasurementData& operator=(const TMeasurementData&);
};

#endif
