/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef MEASUREMENTEDITWIDGETHEADERFILE
#define MEASUREMENTEDITWIDGETHEADERFILE

#include <QWidget>

#include "../../core/vector3.h"

class QLineEdit;
class QToolButton;

class TMeasurementEditWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TMeasurementEditWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TMeasurementEditWidget(void);

// ACCESSORS
	double Nominal_Length(void) const;
	double Actual_Length(void) const;
	
	TVector3 Position(void) const;
	TVector3 Axis(void) const;
	
	int Id(void) const {return d_id;}

// MANIPULATORS
	void Set_Nominal_Length(const double &length);
	void Set_Actual_Length(const double &length);

	void Set_Position(const TVector3 &pos);
	void Set_Axis(const TVector3 &vec);
	
	void Set_Id(const int id) {d_id = id;}
	void Clear_Display(void);

signals:
	void Data_Changed(void);

private slots:
	void Text_Edited(void);

private:
	QLineEdit							*d_actual_edit;
	QLineEdit							*d_i_edit;
	QLineEdit							*d_j_edit;
	QLineEdit							*d_k_edit;
	QLineEdit							*d_nominal_edit;
	QLineEdit							*d_x_edit;
	QLineEdit							*d_y_edit;
	QLineEdit							*d_z_edit;
	
	int									d_id;

// NOT IMPLEMENTED
	TMeasurementEditWidget(const TMeasurementEditWidget&);
	TMeasurementEditWidget& operator=(const TMeasurementEditWidget&);
};

#endif
