/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef INTERPOLATIONHEADERFILE
#define INTERPOLATIONHEADERFILE

#include <vector>

#include "vector2.h"
#include "vector3.h"

namespace Regression
{
	bool Get_Slope_Through_Zero(const std::vector<TVector2> &pnts,double *slope);				// slope of data relative to X0Y0
	bool Get_Endfit_Slope(const std::vector<TVector2> &pnts,double *slope);						// slope of data relative to first and last data point
	bool Fit_Line(const std::vector<TVector2> &pnts,double *slope,double *yintercept=0);		// Linear Regression fit of data
};

namespace LeastSquares
{
	bool Fit_Curve(const std::vector<TVector2> &pnts,double *a,double *b,double *c);						// quad    y = ax^2 + bx + c
	bool Fit_Curve(const std::vector<TVector2> &pnts,double *a,double *b,double *c,double *d);				// cubic   y = ax^3 + bx^2 + cx + d
	bool Fit_Curve(const std::vector<TVector2> &pnts,double *a,double *b,double *c,double *d,double *e);	// quartic y = ax^4 + bx^3 + cx^2 + dx + e
};

namespace Extrapolation
{
	// Routine for TVector2 expect 'x' is the position and 'y' is the value
	// Values are extrapolated if outside of range
	bool Get_Value(const std::vector<TVector2> &pnts,const double &position,double *value);
	
	bool Get_Value_XY(const std::vector<TVector3> &pnts,const double &z_position,double *x_value,double *y_value);
	bool Get_Value_YZ(const std::vector<TVector3> &pnts,const double &x_position,double *y_value,double *z_value);
	bool Get_Value_ZX(const std::vector<TVector3> &pnts,const double &y_position,double *z_value,double *x_value);
};

#endif
