/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef XMLFILEHEADERFILE
#define XMLFILEHEADERFILE

#include <QtXml/QDomDocument>
#include <QtXml/QDomElement>
#include <QtXml/QDomNode>
#include <QString>

class TXmlFileException
{
public:

enum TExceptionType
{
	FILE_OPEN_ERROR=0,
	FILE_DATA_ERROR
};
// CREATORS
	TXmlFileException(const QString &error,const TExceptionType type=FILE_DATA_ERROR);
	~TXmlFileException(void);

// ACCESSORS
	QString ErrorText(void) const {return d_error_text;}
	TExceptionType ErrorType(void) const {return d_error_type;}

private:
	QString								d_error_text;
	TExceptionType						d_error_type;
};

class TXmlFile
{
public:
// CREATORS
	TXmlFile(void);
	~TXmlFile(void);

// ACCESSORS
	QString 		File_Name(void) const {return d_file_name;}
	QDomElement* 	Root_Node(void) {return &d_root_node;}

	// Reading
	void 			Open(const QString &identification,int *version_number=0,const bool process_namespace = true);
	void 			Open_Data(const QByteArray &data,const QString &identification,int *version_number=0,const bool process_namespace = true);
	QString 		Document_Type(void) const {return d_document_type;}	// for '!DOCTYPE'
	QString 		Read_Text_Node(const QDomNode *Node,const bool Optional=false) const;
	QString 		Read_Text_Node(const QDomElement *Node,const bool Optional=false) const;
	QString 		Read_Attribute(const QDomElement *Node,const QString &Name,const bool Optional=false) const;
	QString 		Read_Attribute(const QDomNode *Node,const QString &Name,const bool Optional=false) const;

	QDomElement 	Get_Node(const QDomElement *Parent,const QString &Name,const bool Optional=false) const;
	QDomElement 	Get_Node(const QDomNode *Parent,const QString &Name,const bool Optional=false) const;
	QDomElement 	Get_Sibling_Node(const QDomElement *CurrentNode,const QString &Name,const bool Optional=false) const;
	QDomNode	 	Get_First_Node(const QDomElement *Parent,const bool Optional=false) const;
	QDomNode	 	Get_First_Node(const QDomNode *Parent,const bool Optional=false) const;
	QDomNode	 	Get_Sibling_Node(const QDomNode *CurrentNode,const bool Optional=false) const;

// MANIPULATORS
	void 			Set_File_Name(const QString &File_Name) {d_file_name = File_Name;}
	QDomElement 	Create_Node(QDomElement *ParentNode,const QString &Name);
	void			Clear(void);	// clear all data

	// Writing
	void 			Reset(const QString &identification,const int version_number);
	void 			Reset(const QString &doc_type,const QString &identification,const int version_number);
	void 			Write_Text_Node(QDomElement *Node,const QString &Data);
	void 			Write_Text_Node(QDomElement *Node,const double &Value,const int Precision=6);
	void 			Write_Text_Node(QDomElement *Node,const int Value);
	void 			Write_Attribute(QDomElement *Node, const QString &Name,const QString &Attribute);
	void 			Write_Attribute(QDomElement *Node, const QString &Name,const double &Attribute,const int Precision=6);
	void 			Write_Attribute(QDomElement *Node, const QString &Name,const int Attribute);

	void 			Write_File(const bool inline_xml = false);
	void			Write_Data(QByteArray * const data,const bool inline_xml = false);

private:
	QDomDocument						d_dom_document;
	QDomElement							d_root_node;
	QString								d_file_name;
	QString								d_file_identification;
	QString								d_document_type;

// NOT IMPLEMENTED
	TXmlFile(const TXmlFile&);
	TXmlFile& operator=(const TXmlFile&);
};

#endif
