CONFIG +=			release \
					warn_on \
					qt \
					thread \
					c++11

TEMPLATE =			app
DESTDIR =			bin

CONFIG(debug, debug|release) {
	TARGET =		lengthcompared
} else {
	TARGET =		lengthcompare
}

OBJECTS_DIR =		build/obj
MOC_DIR =			build/moc

QT +=				core \
					gui \
					xml

greaterThan(QT_MAJOR_VERSION, 4): {
QT +=				widgets

}

# DEPENDPATH +=		<relative path>/lib
# INCLUDEPATH +=	<relative path>/src
# LIBS+=			-L<relative path>/lib -l<library name>

SOURCES +=			../core/graphwidget.cpp \
					../core/interpolation.cpp \
					../core/messagebox.cpp \
					../core/vector2.cpp \
					../core/vector3.cpp \
					../core/xmlfile.cpp \
					src/entrywidget.cpp \
					src/lengthcompare.cpp \
					src/main.cpp \
					src/optionsdialog.cpp

HEADERS +=			../core/graphwidget.h \
					../core/interpolation.h \
					../core/messagebox.h \
					../core/vector2.h \
					../core/vector3.h \
					../core/xmlfile.h \
					src/entrywidget.h \
					src/lengthcompare.h \
					src/optionsdialog.h \
					src/types.h

RESOURCES +=		res/lengthcompare.qrc

macx{

ICON =				res/icons.icns

QMAKE_INFO_PLIST = ../default_data/Info.plist
}

linux-g++{

isEmpty(PREFIX) {
PREFIX = 			/usr/lib/lengthcompare
}
target.path =		$$PREFIX
target.files =		bin/lengthcompare
INSTALLS +=			target

# QMAKE_POST_LINK = patchelf --set-rpath ./qtlibs bin/lengthcompare
}

win32 {
RC_FILE =			res/resource.rc
}
