/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef ENTRYWIDGETHEADERFILE
#define ENTRYWIDGETHEADERFILE

#include <QWidget>
#include <QFont>
#include <vector>

#include "types.h"

class QLineEdit;
class QLabel;
class QToolButton;
class QListWidget;

class TEntryWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TEntryWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TEntryWidget(void);

// ACCESSORS
	std::vector<Type::TEntryItem> Entry_Items(void) const;
	double Entry_Offset(void) const;

// MANIPULATORS
	void Clear_Entry_Items(void);
	
	void Add_Entry_Item(const Type::TEntryItem &item);
	void Add_Entry_Items(const std::vector<Type::TEntryItem> &items);
	
	void Enable_Entry_Offset(const bool state);
	void Set_Entry_Offset(const double &offset);

signals:
	void Data_Changed(void);

private slots:
	void Selection_Changed(void);
	void Entry_Changed(void);
	
	void Add_Entry(void);
	void Remove_Entry(void);
	
private:
	QLineEdit							*d_offset_edit;
	QLineEdit							*d_nominal_edit;
	QLineEdit							*d_actual_edit;
	QLineEdit							*d_uc_edit;
	QLabel								*d_offset_label;
	QListWidget							*d_entry_list;
	QToolButton							*d_add_button;
	QToolButton							*d_remove_button;
	QFont								d_entry_font;

// NOT IMPLEMENTED
	TEntryWidget(const TEntryWidget&);
	TEntryWidget& operator=(const TEntryWidget&);
};

#endif
