/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef LENGTHCOMPAREHEADERFILE
#define LENGTHCOMPAREHEADERFILE

#include <QMainWindow>

#include "types.h"

class QFrame;
class QWidget;
class QCloseEvent;
class QDragEnterEvent;
class QDropEvent;
class QSettings;
class QAction;

class TGraphWidget;
class TEntryWidget;
class TOptionsDialog;
class TXmlFile;
class TMessageBox;

class TLengthCompare : public QMainWindow
{
Q_OBJECT

public:

// CREATORS
	TLengthCompare(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TLengthCompare(void);

// ACCESSORS
	bool Save_Data(const QString &file_name) const;
	bool Export_Data(const QString &file_name);

// MANIPULATORS
	bool Load_Data(const QString &file_name);

signals:

private slots:
	void Update(void);
	
	void File_Load(void);
	void File_Save(void);
	void File_Export(void);
	void Edit_Options(void);
	void Help_About(void);

protected:
	virtual void closeEvent(QCloseEvent *event);
	virtual void dragEnterEvent(QDragEnterEvent *event);
	virtual void dropEvent(QDropEvent *event);
	
private:
	
struct TExportData
{
	double								position;
	double								dev_a;
	double								dev_b;
	double								uc_a_raw;
	double								uc_a;
	double								uc_b;
	double								uc_en;
	bool								dev_a_valid;
	bool								dev_b_valid;
	bool								uc_a_valid;
	bool								uc_b_valid;
};
	
	QAction								*d_action_open;
	QAction								*d_action_save;
	QAction								*d_action_export;
	QAction								*d_action_options;
	QAction								*d_action_about;
	QAction								*d_action_quit;
	TEntryWidget						*d_entry_a_widget;
	TEntryWidget						*d_entry_b_widget;
	QSettings							*d_settings;
	
	TGraphWidget						*d_graph_data_widget;
	TGraphWidget						*d_graph_en_widget;
	TOptionsDialog						*d_options_dialog;
	TMessageBox							*d_msg_box;

	Type::TOptions						d_options;
	std::vector<double>					d_sample_positions;
	std::vector<TExportData>			d_export_data;
	double								d_data_b_deviation_offset;
	QString								d_file_path;
	bool								d_data_changed;
	
	mutable QString						d_last_error;
	
	void Add_Graph_Position(const double &position);
	void Load_Data_V1(TXmlFile * const xml_file);
	void Load_Data_V2(TXmlFile * const xml_file);


// NOT IMPLEMENTED
	TLengthCompare(const TLengthCompare&);
	TLengthCompare& operator=(const TLengthCompare&);
};

#endif
