/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QCheckBox>
#include <QFont>
#include <QFrame>
#include <QHBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QSpacerItem>
#include <QVBoxLayout>

#include "optionsdialog.h"

TOptionsDialog::TOptionsDialog(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QDialog(const_cast<QWidget*>(parent),flags)
{
	QFont								font;
	QFrame								*horizontal_separator;
	QHBoxLayout							*button_hlayout;
	QLabel								*options_label;
	QSpacerItem							*button_hspacer;
	QSpacerItem							*control_vspacer;
	QVBoxLayout							*dialog_vlayout;

	font.setPointSize(14);
	font.setItalic(true);
	font.setUnderline(true);

	this->resize(400,300);

	dialog_vlayout = new QVBoxLayout(this);

	options_label = new QLabel(this);
	options_label->setFont(font);
	dialog_vlayout->addWidget(options_label);

	d_remove_deviation_check = new QCheckBox(this);
	dialog_vlayout->addWidget(d_remove_deviation_check);

	control_vspacer = new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);
	dialog_vlayout->addItem(control_vspacer);

	horizontal_separator = new QFrame(this);
	horizontal_separator->setFrameShape(QFrame::HLine);
	horizontal_separator->setFrameShadow(QFrame::Sunken);
	dialog_vlayout->addWidget(horizontal_separator);

	button_hlayout = new QHBoxLayout();

	button_hspacer = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
	button_hlayout->addItem(button_hspacer);

	d_cancel_button = new QPushButton(this);
	d_cancel_button->setAutoDefault(false);
	button_hlayout->addWidget(d_cancel_button);

	d_accept_button = new QPushButton(this);
	d_accept_button->setAutoDefault(false);
	d_accept_button->setDefault(true);
	button_hlayout->addWidget(d_accept_button);
	dialog_vlayout->addLayout(button_hlayout);

	this->setWindowTitle(QStringLiteral("Options"));
	
	options_label->setText(QStringLiteral("Options"));
	d_remove_deviation_check->setText(QStringLiteral("Align Deviations and Adjust Uncertainty"));
	d_cancel_button->setText(QStringLiteral("Cancel"));
	d_accept_button->setText(QStringLiteral("Accept"));
	
	connect(d_cancel_button,&QPushButton::clicked,this,&TOptionsDialog::reject);
	connect(d_accept_button,&QPushButton::clicked,this,&TOptionsDialog::accept);
}

TOptionsDialog::~TOptionsDialog(void)
{
}

Type::TOptions TOptionsDialog::Options(void) const
{
	Type::TOptions						options;
	
	options.remove_deviations = d_remove_deviation_check->isChecked();
	
	return options;
}

void TOptionsDialog::Reset(
	const Type::TOptions				options)
{
	d_remove_deviation_check->setChecked(options.remove_deviations);
}


