/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2025  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef OPTIONSDIALOGHEADERFILE
#define OPTIONSDIALOGHEADERFILE

#include <QDialog>

#include "types.h"

class QCheckBox;
class QPushButton;

class TOptionsDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TOptionsDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TOptionsDialog(void);

// ACCESSORS
	Type::TOptions Options(void) const;

// MANIPULATORS
	void Reset(const Type::TOptions);

signals:

private slots:

private:
	QCheckBox							*d_remove_deviation_check;
	QPushButton							*d_accept_button;
	QPushButton							*d_cancel_button;

// NOT IMPLEMENTED
	TOptionsDialog(const TOptionsDialog&);
	TOptionsDialog& operator=(const TOptionsDialog&);
};

#endif
