/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef BESTFITPLANEHEADERFILE
#define BESTFITPLANEHEADERFILE

#include "vector3.h"

class TBestFitPlane
{
public:
// CREATORS
	TBestFitPlane(void);
	~TBestFitPlane(void);

// ACCESSORS
	TVector3 Position(void) const {return d_position;}
	TVector3 Axis(void) const {return d_axis;}
	double FormError(void) const {return d_form_error;}

// MANIPULATORS
	bool Fit(const int number_of_points,const TVector3 *points);

private:

	TVector3							d_position;
	TVector3							d_axis;
	double								d_form_error;

	void Calculate_Form_Error(const int number_of_points,const TVector3 *points);
	void Get_Eigen_Values(const double *mat,const int n,double *eigen_vectors,double *eigen_values);

// NOT IMPLEMENTED
	TBestFitPlane(const TBestFitPlane&);
	TBestFitPlane& operator=(const TBestFitPlane&);

};

#endif

