/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef BESTFITSPHEREHEADERFILE
#define BESTFITSPHEREHEADERFILE

#include "vector3.h"

class TBestFitSphere
{
public:
// CREATORS
	TBestFitSphere(void);
	~TBestFitSphere(void);

// ACCESSORS
	TVector3 Position(void) const {return d_Position;}
	double Radius(void) const {return d_Radius;}
	double Diameter(void) const {return d_Radius * 2;}
	double FormError(void) const {return d_FormError;}

// MANIPULATORS
	bool Fit(const int NumPoints,const TVector3 *Points);

private:

	TVector3							d_Position;
	double								d_Radius;
	double								d_FormError;

	void CalcFormError(const int NumPoints,const TVector3 *Points);

// NOT IMPLEMENTED
	TBestFitSphere(const TBestFitSphere&);
	TBestFitSphere& operator=(const TBestFitSphere&);

};

#endif

