/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef MATRIXHEADERFILE
#define MATRIXHEADERFILE

class TMatrix
{
public:

// CREATORS
	TMatrix(void);
	TMatrix(const int Rows,const int Columns);
	TMatrix(const TMatrix&);
	TMatrix& operator=(const TMatrix&);
	~TMatrix(void);

// ACCESSORS
	double 		At(const int Row,const int Column) const;
	int 		Columns(void) const {return d_Columns;}
	int 		Rows(void) const {return d_Rows;}

// MANIPULATORS
	void 		At(const int Row,const int Column,const double &Value);
	void 		Add(const int Row,const int Column,const double &Value);
	void 		Subtract(const int Row,const int Column,const double &Value);
	void 		Multiply(const int Row,const int Column,const double &Value);
	void 		Transpose(void);
	bool 		Invert(void);
	void 		Resize(const int Rows,const int Columns);
	void 		SwapRows(const int Row1,const int Row2);
	void 		SwapColumns(const int Column1,const int Column2);

	TMatrix& 	operator+=(const TMatrix &rhs);
	TMatrix& 	operator-=(const TMatrix &rhs);

	void 		Zero(void);

private:
	double								*d_Data;
	int									d_Columns;
	int									d_Rows;

// NOT IMPLEMENTED
};

TMatrix operator*(const TMatrix &lhs,const TMatrix &rhs);

inline double TMatrix::At(
	const int							Row,
	const int							Column) const
{
	assert(Column < d_Columns);
	assert(Row < d_Rows);

	return d_Data[Column * d_Rows + Row];
}

inline void TMatrix::At(
	const int							Row,
	const int							Column,
	const double						&Value)
{
	assert(Column < d_Columns);
	assert(Row < d_Rows);

	d_Data[Column * d_Rows + Row] = Value;
}	

inline void TMatrix::Add(
	const int							Row,
	const int							Column,
	const double						&Value)
{
	assert(Column < d_Columns);
	assert(Row < d_Rows);

	d_Data[Column * d_Rows + Row] += Value;
}	

inline void TMatrix::Subtract(
	const int							Row,
	const int							Column,
	const double						&Value)
{
	assert(Column < d_Columns);
	assert(Row < d_Rows);

	d_Data[Column * d_Rows + Row] -= Value;
}	

inline void TMatrix::Multiply(
	const int							Row,
	const int							Column,
	const double						&Value)
{
	assert(Column < d_Columns);
	assert(Row < d_Rows);

	d_Data[Column * d_Rows + Row] *= Value;
}	

bool MatrixInverse(const TMatrix &rkA,TMatrix &rkInvA);

#endif
