/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef TABLEEDITORHEADERFILE
#define TABLEEDITORHEADERFILE

#include <QTableWidget>
#include <QLineEdit>
#include <QRect>
//#include <vector>

class QKeyEvent;
class QFocusEvent;
class QContextMenuEvent;
class QAction;

class TTableLineEditor : public QLineEdit
{
	Q_OBJECT
	
public:
	
// CREATORS
	TTableLineEditor(QWidget *Parent=0);
	virtual ~TTableLineEditor(void);
	
// ACCESSORS
	
// MANIPULATORS
	
signals:
	
	void Edit_Complete(void);
	
private:
	
	virtual void keyPressEvent(QKeyEvent *KeyEvent);
	virtual void focusOutEvent(QFocusEvent *FocusEvent);
	
// NOT IMPTLEMENTED
	TTableLineEditor(const TTableLineEditor&);
	TTableLineEditor& operator=(const TTableLineEditor&);
};

class TEditTable : public QTableWidget
{
Q_OBJECT

public:
	
enum TEditMode
{
	EDIT_MODE_REPLACE=0,
	EDIT_MODE_APPEND
};
	
enum TSelectionMode
{
	SELECTION_MODE_DOWN=0,
	SELECTION_MODE_UP
};
	
// CREATORS
	TEditTable(QWidget *Parent=0);
	virtual ~TEditTable(void);

// ACCESSORS
	virtual QSize sizeHint(void) const;
	virtual QSize minimumSizeHint(void) const;

	double Cell_Value(const int row,const int column) const;
	double* Cell_Values(void) const {return d_cell_data;}
	int	Row_Count(void) const {return d_row_count;}
	int Column_Count(void) const {return d_column_count;}
	QRect Current_Selection(void) const {return d_selection_rect;}
	
	int Row_Column_To_Offset(const int row,const int column) const;
	void Offset_To_Row_Column(int *row,int *column,const int offset) const;

// MANIPULATORS
	void Set_Cell_Count(const int rows,const int columns);
	void Set_Cell_Value(const int row,const int column,const double &value);
	void Set_Cell_Values(const double *values);
	void Set_Edit_Mode(const TEditMode &edit_mode);
	void Set_Selection_Mode(const TSelectionMode &selection_mode);
	void Set_Display_Precision(const int precision);
	void Resize_Columns_To_Contents(const bool force_min_width = false);	// set minimum width to ensure all columns are visible
	
	void Enable_Invert_Action(const bool state) {d_enable_invert_action = state;}
	void Set_Read_Only_Mode(const bool state) {d_readonly_mode = state;}
		
signals:
	void Selection_Changed(void);
	void Cell_Changed(const int row,const int column,const double &value);
	void Start_Multiple_Cell_Change(const QString&);	// cut, paste, delete of selected cells.  Individual changes through 'cell_changed'
	void End_Multiple_Cell_Change(void);

protected:	
	virtual void keyPressEvent(QKeyEvent *key_event);
	virtual void focusOutEvent(QFocusEvent *focus_event);
	virtual void contextMenuEvent(QContextMenuEvent *menu_event);
	
private slots:
	void Table_Selection_Changed(void);
	void Activate_Cell(int row,int column);
	void Cell_Editor_Changed(void);
	void Cell_Editor_Closed(void);
	
	void Clipboard_Data_Changed(void);
	void Edit_Cut(void);
	void Edit_Copy(void);
	void Edit_Delete(void);
	void Edit_Paste(void);
	void Edit_Invert(void);

private:
	TTableLineEditor					*d_table_editor;
	
	QAction								*d_cut_action;
	QAction								*d_copy_action;
	QAction								*d_paste_action;
	QAction								*d_delete_action;
	QAction								*d_invert_action;
	
	bool								d_enable_invert_action;
	bool								d_readonly_mode;
	
	bool								d_table_editor_changed;
	int									d_row_count;
	int									d_column_count;
	double								*d_cell_data;
	TEditMode							d_edit_mode;
	TSelectionMode						d_selection_mode;
	QRect								d_selection_rect;
	int									d_display_precision;

// NOT IMPLEMENTED
	TEditTable(const TEditTable&);
	TEditTable& operator=(const TEditTable&);
};


#endif

