/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include "serial.h"
#include "libserialdevice.h"

LSerialDevice::LSerialDevice(void)
{
	d_serial = new TSerial;
}

LSerialDevice::~LSerialDevice(void)
{
	delete d_serial;
}

QString LSerialDevice::errorString(void) const
{
	return d_serial->errorString();
}

bool LSerialDevice::isOpen(void) const
{
	return d_serial->isOpen();
}

int LSerialDevice::bytesAvailable(void) const
{
	return d_serial->bytesAvailable();
}

int LSerialDevice::read(
	char								*data,
	int									max_size) const
{
	return d_serial->read(data,max_size);
}

QByteArray LSerialDevice::read(
	int									max_size) const
{
	QByteArray							data;
	
	if(max_size > 0)
	{
		data.resize(max_size);
		
		d_serial->read(data.data(),max_size);
	}
	
	return data;
}

QByteArray LSerialDevice::readAll(void) const
{
	QByteArray							data;
	int									size;
	
	size = d_serial->bytesAvailable();
	
	if(size > 0)
	{
		data.resize(size);
		
		d_serial->read(data.data(),size);
	}
	
	return data;
}

QString LSerialDevice::portName(void) const
{
	return d_serial->portName();
}

QString LSerialDevice::baudRate(void) const
{
	return d_serial->baudRate();
}

QString LSerialDevice::dataBits(void) const
{
	return d_serial->dataBits();
}

QString LSerialDevice::parity(void) const
{
	return d_serial->parity();
}

QString LSerialDevice::stopBits(void) const
{
	return d_serial->stopBits();
}

QString LSerialDevice::flowControl(void) const
{
	return d_serial->flowControl();
}

bool LSerialDevice::getChar(
	char								*c)
{
	return (1 == d_serial->read(c,1));
}

bool LSerialDevice::setPortName(
	const QString						&name)
{
	return d_serial->setPortName(name);
}

bool LSerialDevice::setBaudRate(
	const TLibSerialDeviceEnum::TBaudRate	baud_rate)
{
	return d_serial->setBaudRate(baud_rate);
}

bool LSerialDevice::setDataBits(
	const TLibSerialDeviceEnum::TDataBits data_bits)
{
	return d_serial->setDataBits(data_bits);
}

bool LSerialDevice::setParity(
	const TLibSerialDeviceEnum::TParity parity)
{
	return d_serial->setParity(parity);
}

bool LSerialDevice::setStopBits(
	const TLibSerialDeviceEnum::TStopBits stop_bits)
{
	return d_serial->setStopBits(stop_bits);
}

bool LSerialDevice::setFlowControl(
	const TLibSerialDeviceEnum::TFlowControl flow_control)
{
	return d_serial->setFlowControl(flow_control);
}

bool LSerialDevice::setDataTerminalReady(
	const bool							state)
{
	return d_serial->setDataTerminalReady(state);
}

bool LSerialDevice::setRequestToSend(
	const bool							state)
{
	return d_serial->setRequestToSend(state);
}

int LSerialDevice::write(
	const char							*data,
	const int							max_size,
	const bool							block_until_written)
{
	return d_serial->write(data,max_size,block_until_written);
}

int LSerialDevice::write(
	const QByteArray					&data,
	const bool							block_until_written)
{
	return d_serial->write(data.constData(),data.size(),block_until_written);
}

bool LSerialDevice::purge(void)
{
	return d_serial->purge();
}

bool LSerialDevice::open(void)
{
	return d_serial->open();
}

void LSerialDevice::close(void)
{
	d_serial->close();
}
