/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef LIBSERIALDEVICEHEADERFILE
#define LIBSERIALDEVICEHEADERFILE

#if defined CONFIGURE_DLL_EXPORT
#define DLL_EXPORT_CONFIGURE  Q_DECL_EXPORT
#else
#define DLL_EXPORT_CONFIGURE Q_DECL_IMPORT
#endif

#include <QString>
#include <QByteArray>

#include "libserialdeviceenum.h"		// define various parameters used to interact with library

class TSerial;

class DLL_EXPORT_CONFIGURE LSerialDevice
{
public:
	
// CREATORS
	LSerialDevice(void);
	~LSerialDevice(void);
	
// ACCESSORS
	QString errorString(void) const;
	bool isOpen(void) const;
	
	int bytesAvailable(void) const;
	int read(char *data,int max_size) const;
	QByteArray read(int max_size) const;
	QByteArray readAll(void) const;
	bool getChar(char *c);
	
	QString portName(void) const;
	QString baudRate(void) const;
	QString dataBits(void) const;
	QString parity(void) const;
	QString stopBits(void) const;
	QString flowControl(void) const;

	
// MANIPULATORS
	bool setPortName(const QString &name);
	bool setBaudRate(const TLibSerialDeviceEnum::TBaudRate baud_rate);
	bool setDataBits(const TLibSerialDeviceEnum::TDataBits data_bits);
	bool setParity(const TLibSerialDeviceEnum::TParity parity);
	bool setStopBits(const TLibSerialDeviceEnum::TStopBits stop_bits);
	bool setFlowControl(const TLibSerialDeviceEnum::TFlowControl flow_control);
	
	bool setDataTerminalReady(const bool state);
	bool setRequestToSend(const bool state);
	
	int write(const char *data,const int max_size,const bool block_until_written);
	int write(const QByteArray &data,const bool block_until_written);
	bool purge(void);

	bool open(void);
	void close(void);

private:
	
	TSerial								*d_serial;		// compilation firewall
	
// NOT IMPLEMENTED
	LSerialDevice(const LSerialDevice&);
	LSerialDevice& operator=(const LSerialDevice&);
};

/*
 Notes
 
 This is intended to be used in a thread.  It is a simple wrapper to the native OS serial port functions.
 
 The write options can be made to block by setting the blocking function to tru, the read functions are non-blocked.
 
 */


#endif
