/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef SERIALDEVICEHEADERFILE
#define SERIALDEVICEHEADERFILE

#include <QtGlobal>
#include <QString>

#if defined (Q_OS_WIN)

#ifndef UNICODE
#define UNICODE
#endif

#include <windows.h>
#else
#include <termios.h>
#endif

#include "libserialdeviceenum.h"

class TSerial
{
public:
// CREATORS
	TSerial(void);
	~TSerial(void);
	
// ACCESSORS
	QString errorString(void) const {return d_last_error;}
	bool isOpen(void) const;

	int bytesAvailable(void) const;
	int read(char *data,int max_size) const;
	
	QString portName(void) const;
	QString baudRate(void) const;
	QString dataBits(void) const;
	QString parity(void) const;
	QString stopBits(void) const;
	QString flowControl(void) const;

// MANIPULATORS
	bool setPortName(const QString &name);
	bool setBaudRate(const TLibSerialDeviceEnum::TBaudRate baud_rate);
	bool setDataBits(const TLibSerialDeviceEnum::TDataBits data_bits);
	bool setParity(const TLibSerialDeviceEnum::TParity parity);
	bool setStopBits(const TLibSerialDeviceEnum::TStopBits stop_bits);
	bool setFlowControl(const TLibSerialDeviceEnum::TFlowControl flow_control);
	
	bool setDataTerminalReady(const bool state);
	bool setRequestToSend(const bool state);

	int write(const char *data,int max_size,const bool block_until_written);
	bool purge(void);

	bool open(void);
	void close(void);

private:
	
#ifdef Q_OS_WIN
	DCB									d_device_control_block;
	DCB									d_device_control_block_original;
	COMMTIMEOUTS						d_comm_timeouts;
	COMMTIMEOUTS						d_comm_timeouts_original;
	HANDLE								d_comm_handle;

	DWORD Convert_Baud(const TLibSerialDeviceEnum::TBaudRate &baud_rate) const;

#else
	int									d_comm_handle;
	struct termios						d_termios;
	struct termios						d_termios_original;
	
	speed_t Convert_Baud(const TLibSerialDeviceEnum::TBaudRate &baud_rate) const;
	unsigned int Get_Current_Baud_Rate(void) const;
	
#endif
	
	QString								d_port_name;
	
	TLibSerialDeviceEnum::TBaudRate		d_baud_rate;
	TLibSerialDeviceEnum::TDataBits		d_data_bits;
	TLibSerialDeviceEnum::TParity		d_parity;
	TLibSerialDeviceEnum::TStopBits		d_stop_bits;
	TLibSerialDeviceEnum::TFlowControl	d_flow_control;
	
	bool Update_Comm_Parameters(void);
	void Intialize_Variables(void);
	
	mutable QString						d_last_error;
	
// NOT IMPLEMENTED
	TSerial(const TSerial&);
	TSerial& operator=(const TSerial&);
};

#endif

