/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////



#ifndef CMMWIDGETHEADERFILE
#define CMMWIDGETHEADERFILE

#include <QWidget>

#include "controller.h"
#include "driver.h"

class QComboBox;
class QLabel;

class TIconWidget;
class TTitleWidget;
class TLogDialog;
class TTemperatureMonitorDialog;

class TCMMWidget : public QWidget
{
Q_OBJECT

public:
	
struct TTemperatureSettings
{
	double								upper_temperature_limit;
	double								lower_temperature_limit;
};

// CREATORS
	TCMMWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TCMMWidget(void);

// ACCESSORS
	TController::TControllerType Controller_Type(void) const;
	TDriver::TDriverState Driver_State(void) const {return d_driver_state;}
	TCMMWidget::TTemperatureSettings Temperature_Settings(void) const;

// MANIPULATORS
	void Set_Controller_Type(const TController::TControllerType type);
	void Set_Driver_State(const TDriver::TDriverState state);
	void Set_Temperature_Settings(const TCMMWidget::TTemperatureSettings &settings);
	void Set_Sensor_Value(int sensor_id,const double &value,const QString &log_path);
	
	void Set_Temperature_Sensors_X(const QString &sensors);
	void Set_Temperature_Sensors_Y(const QString &sensors);
	void Set_Temperature_Sensors_Z(const QString &sensors);
	void Set_Temperature_Sensors_Part(const QString &sensors);

	void Enable_Disconnect_Option(const bool state);
	void Enable_Options(const bool home,const bool exercise,const bool temperature);

	void Clear_Log(void);
	void Add_Log_Text(const QString &text);

signals:
	void Connect(void);
	void Disconnect(void);
	void Home(void);
	void Exercise_Machine(void);
	void Request_Sensor_Value(int);

private slots:
	void Log_Clicked(void);
	void Toggle_Temperature_Monitor_Dialog(void);
	void Temperature_Limits_Changed(void);

private:
	QComboBox							*d_controller_type_combo;
	QLabel								*d_status_label;
	TIconWidget							*d_connect_option;
	TIconWidget							*d_disconnect_option;
	TIconWidget							*d_log_option;
	TIconWidget							*d_home_option;
	TIconWidget							*d_exercise_option;
	TIconWidget							*d_temperature_monitor_option;
	TLogDialog							*d_log_dialog;
	TTemperatureMonitorDialog			*d_temperature_monitor_dialog;

	TDriver::TDriverState				d_driver_state;
	TTemperatureSettings				d_temperature_settings;

// NOT IMPLEMENTED
	TCMMWidget(const TCMMWidget&);
	TCMMWidget& operator=(const TCMMWidget&);
};

#endif
