/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COMMANDALIGNHEADERFILE
#define COMMANDALIGNHEADERFILE

#include <vector>

#include "../../../core/vector3.h"
#include "../../../core/referencesystem.h"

#include "command.h"

class TCommandAlign : public TCommand
{
public:
	
enum TCommandAlignFunction
{
	TYPE_SKEW1 = 0,
	TYPE_SKEW1_PROBE_AXIS,
	TYPE_SKEW2,
	TYPE_SKEW2_PROBE_AXIS,
	TYPE_SKEW2_STEM_AXIS,
	TYPE_ORIGIN,
	TYPE_ORIGIN_OFFSET
};
	
struct TAlignStep
{
	TCommandAlignFunction				command_function;
	int									memory_id;
	double								value;
	TReferenceSystem::TAxis				axis;
	TReferenceSystem::TAxis				projection_axis;
};
	
	// CREATORS
	TCommandAlign(void);
	virtual ~TCommandAlign(void);
	
	// ACCESSORS
	int Alignment_Step_Count(void) const {return static_cast<int>(d_alignment_steps.size());}
	TAlignStep Alignment_Step(const int index) const;
	
	// MANIPULATORS
	void Clear_Align_Steps(void);
	void Add_Align_Step(const TAlignStep &step);
		
private:
	std::vector<TAlignStep>		d_alignment_steps;

	// NOT IMPLEMENTED
	TCommandAlign(const TCommandAlign&);
	TCommandAlign& operator=(const TCommandAlign&);
};


#endif
