/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <vector>
#include <assert.h>

#include "../../../core/bestfitcircle.h"
#include "pathpoint.h"

#include "command_feature_circle.h"

TCommandCircle::TCommandCircle(
	const int							memory_id)
:TCommandFeature(memory_id)
{
	d_command_type = TCommand::COMMAND_MEASURE_CIRCLE;
	
	d_form_error = 0.0;
}

TCommandCircle::~TCommandCircle(void)
{
}

bool TCommandCircle::Calculate_Feature(
	const TVector3						&projection_axis,
	const double						&tip_radius)
{
	std::vector<TPathPoint>::const_iterator iter;
	std::vector<TVector3>				pnts;
	TBestFitCircle						circle;
	TVector3							pnt_ijk;
	TVector3							pnt_xyz;
	static const double					ZERO_EPSILON(0.000001);
	
	this->Clear_Actual();

	if(!this->Calculate_Nominal())
	{
		return false;
	}

	for(iter = d_actual_points.begin();iter != d_actual_points.end();++iter)
	{
		if((*iter).Type() == TPathPoint::TOUCH_POINT)
		{
			pnts.push_back((*iter).XYZ());
			pnt_xyz = (*iter).XYZ();
			pnt_ijk = (*iter).IJK();
		}
	}
	
	if(!circle.Fit(projection_axis,pnts.size(),&pnts[0]))
	{
		return false;
	}
	
	if(pnt_ijk.Length() > ZERO_EPSILON)
	{
		pnt_ijk.Normal();
	}
	else
	{
		assert(false);
		pnt_ijk.Set(0,1,0);	// should never get here
	}
	
	d_actual_xyz = circle.Position();
	d_actual_ijk = circle.Axis();
	d_actual_diameter = circle.Diameter();
	
	pnt_xyz -= d_actual_xyz;

	// check for ID/OD
	if((pnt_xyz ^ pnt_ijk) > 0)	// ID
	{
		d_actual_diameter += (tip_radius * 2.0);
		d_actual_diameter_type = TCommandFeature::DIAMETER_TYPE_ID;
	}
	else	// OD
	{
		d_actual_diameter -= (tip_radius * 2.0);
		d_actual_diameter_type = TCommandFeature::DIAMETER_TYPE_OD;
	}
	
	d_form_error = circle.FormError();
	
	return true;
}

bool TCommandCircle::Calculate_Nominal(void)
{
	std::vector<TPathPoint>::const_iterator iter;
	std::vector<TVector3>				pnts;
	TBestFitCircle						circle;
	
	this->Clear_Nominal();

	for(iter = d_nominal_points.begin();iter != d_nominal_points.end();++iter)
	{
		if((*iter).Type() == TPathPoint::TOUCH_POINT)
		{
			pnts.push_back((*iter).XYZ());
		}
	}
		
	if(!circle.Fit(d_nominal_projection_axis,pnts.size(),&pnts[0]))
	{
		return false;
	}
	
	d_nominal_xyz = circle.Position();
	d_nominal_ijk = circle.Axis();
	d_nominal_diameter = circle.Diameter();

	return true;
}





