/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <vector>
#include <assert.h>

#include "../../../core/bestfitplane.h"
#include "pathpoint.h"

#include "command_feature_plane.h"

TCommandPlane::TCommandPlane(
	const int							memory_id)
:TCommandFeature(memory_id)
{
	d_command_type = TCommand::COMMAND_MEASURE_PLANE;
	
	d_form_error = 0.0;
}

TCommandPlane::~TCommandPlane(void)
{
}

bool TCommandPlane::Calculate_Feature(
	const TVector3						&projection_axis,
	const double						&tip_radius)
{
	(void)projection_axis;	// Q_UNUSED
	
	std::vector<TPathPoint>::const_iterator iter;
	std::vector<TVector3>				pnts;
	TVector3							pnt_ijk;
	TBestFitPlane						plane;
	static const double					ZERO_EPSILON(0.000001);

	this->Clear_Actual();

	if(!this->Calculate_Nominal())
	{
		return false;
	}

	for(iter = d_actual_points.begin();iter != d_actual_points.end();++iter)
	{
		if((*iter).Type() == TPathPoint::TOUCH_POINT)
		{
			pnts.push_back((*iter).XYZ());
			pnt_ijk = (*iter).IJK();
		}
	}
		
	if(!plane.Fit(pnts.size(),&pnts[0]))
	{
		return false;
	}
	
	d_actual_xyz = plane.Position();
	d_actual_ijk = plane.Axis();
	
	if(pnt_ijk.Length() > ZERO_EPSILON)
	{
		pnt_ijk.Normal();
	}
	else
	{
		assert(false);
		pnt_ijk.Set(0,0,-1);	// should never get here
	}
	
	// check sign of axis
	if((d_actual_ijk ^ pnt_ijk) > 0)
	{
		d_actual_ijk *= (-1.0);
	}
	
	d_touch_approach_vector = d_actual_ijk * (-1.0);
	
	d_actual_xyz -= d_actual_ijk * tip_radius;
	d_form_error = plane.FormError();
	
	return true;
}

bool TCommandPlane::Calculate_Nominal(void)
{
	std::vector<TPathPoint>::const_iterator iter;
	std::vector<TVector3>				pnts;
	TBestFitPlane						plane;
	
	this->Clear_Nominal();

	for(iter = d_nominal_points.begin();iter != d_nominal_points.end();++iter)
	{
		if((*iter).Type() == TPathPoint::TOUCH_POINT)
		{
			pnts.push_back((*iter).XYZ());
		}
	}

	if(!plane.Fit(pnts.size(),&pnts[0]))
	{
		return false;
	}
	
	d_nominal_xyz = plane.Position();
	d_nominal_ijk = plane.Axis();

	return true;
}
