/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <vector>
#include <assert.h>

#include "pathpoint.h"

#include "command_feature_point.h"

static const double						ZERO_EPSILON(0.000001);

TCommandPoint::TCommandPoint(
	const int							memory_id)
:TCommandFeature(memory_id)
{
	d_command_type = TCommand::COMMAND_MEASURE_POINT;
}

TCommandPoint::~TCommandPoint(void)
{
}

TVector3 TCommandPoint::Nominal_Touch_Vector(void)
{
	if(this->Calculate_Nominal())
	{
		return d_nominal_ijk;
	}
	
	return TVector3(0,0,1);
}

bool TCommandPoint::Calculate_Feature(
	const TVector3						&projection_axis,
	const double						&tip_radius)
{
	(void)projection_axis;	// Q_UNUSED
	
	std::vector<TPathPoint>::const_iterator iter;
	TVector3							pnt_sum;
	TVector3							vec_sum;
	int									count(0);

	this->Clear_Actual();

	if(!this->Calculate_Nominal())
	{
		return false;
	}

	for(iter = d_actual_points.begin();iter != d_actual_points.end();++iter)
	{
		if((*iter).Type() == TPathPoint::TOUCH_POINT)
		{
			pnt_sum += (*iter).XYZ();
			vec_sum += (*iter).IJK();
			
			++count;
		}
	}
	
	if(!count)
	{
		return false;
	}
	
	pnt_sum /= static_cast<double>(count);
	vec_sum /= static_cast<double>(count);

	d_actual_xyz = pnt_sum;
	d_actual_ijk = vec_sum;

	assert(vec_sum.Length() > ZERO_EPSILON);

	d_actual_ijk.Normal();
	
	// tip compensation
	d_actual_xyz += d_actual_ijk * tip_radius;

	d_touch_approach_vector = d_actual_ijk;

	return true;
}

bool TCommandPoint::Calculate_Nominal(void)
{
	std::vector<TPathPoint>::const_iterator iter;
	TVector3							pnt_sum;
	TVector3							vec_sum;
	int									count(0);
	
	this->Clear_Nominal();

	for(iter = d_nominal_points.begin();iter != d_nominal_points.end();++iter)
	{
		if((*iter).Type() == TPathPoint::TOUCH_POINT)
		{
			pnt_sum += (*iter).XYZ();
			vec_sum += (*iter).IJK();

			++count;
		}
	}

	if(count)
	{
		pnt_sum /= static_cast<double>(count);
		vec_sum /= static_cast<double>(count);
		
		d_nominal_xyz = pnt_sum;
		d_nominal_ijk = vec_sum;

		assert(vec_sum.Length() > ZERO_EPSILON);

		d_nominal_ijk.Normal();

		return true;
	}
	
	return false;
}

