/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COMMANDMODALMODEHEADERFILE
#define COMMANDMODALMODEHEADERFILE

#include "command_modal.h"

class TCommandMode : public TCommandModal
{
public:
	// CREATORS
	TCommandMode(void);
	virtual ~TCommandMode(void);
	
	// ACCESSORS
	bool Is_Manual_Mode(void) const {return d_manual_mode;}
	bool Is_DCC_Mode(void) const {return !d_manual_mode;}
	
	// MANIPULATORS
	void Set_Manual_Mode(void) {d_manual_mode = true;}
	void Set_DCC_Mode(void) {d_manual_mode = false;}
	
private:
	bool								d_manual_mode;
	
	// NOT IMPLEMENTED
	TCommandMode(const TCommandMode&);
	TCommandMode& operator=(const TCommandMode&);
};

#endif
