/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COMMANDMODALPROMPTHEADERFILE
#define COMMANDMODALPROMPTHEADERFILE

#include <QString>

#include "command_modal.h"

class TCommandPrompt : public TCommandModal
{
public:
	// CREATORS
	TCommandPrompt(void);
	TCommandPrompt(const QString &prompt);
	virtual ~TCommandPrompt(void);
	
	// ACCESSORS
	QString Prompt_Text(void) const {return d_prompt_text;}
	
	// MANIPULATORS
	void Set_Prompt_Text(const QString &text) {d_prompt_text = text;}
	
private:
	
	QString								d_prompt_text;
	
	// NOT IMPLEMENTED
	TCommandPrompt(const TCommandPrompt&);
	TCommandPrompt& operator=(const TCommandPrompt&);
};

#endif

