/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COMMANDMOVEHEADERFILE
#define COMMANDMOVEHEADERFILE

#include <vector>

#include "../../../core/vector3.h"

#include "command.h"

class TCommandMove : public TCommand
{
public:
	
	// CREATORS
	TCommandMove(void);
	virtual ~TCommandMove(void);
	
	// ACCESSORS
	bool Has_Move_Points(void) const {return (d_move_points.size() > 0);}		
	TVector3 Get_Next_Point(bool * const valid);
	
	// MANIPULATORS
	void Add_Point(const TVector3 &pnt);
	
private:
	std::vector<TVector3>				d_move_points;
	
	// NOT IMPLEMENTED
	TCommandMove(const TCommandMove&);
	TCommandMove& operator=(const TCommandMove&);
};

#endif
