/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COMMANDMOVECUBEHEADERFILE
#define COMMANDMOVECUBEHEADERFILE

#include <vector>

#include "../../../core/vector3.h"

#include "command.h"

class TCommandMoveCube : public TCommand
{
public:
	
enum TAxis
{
	XMINUS = 0,
	XPLUS,
	YMINUS,
	YPLUS,
	ZMINUS,
	ZPLUS
};
	
	// CREATORS
	TCommandMoveCube(void);
	virtual ~TCommandMoveCube(void);
	
	// ACCESSORS
	bool Has_Move_Points(void) const {return (d_move_points.size() > 0);}
	TVector3 Get_Next_Point(bool * const valid);
	
	TAxis Axis(void) const {return d_axis;}
	double Position(void) const {return d_position;}
	
	// MANIPULATORS
	void Set_Axis(const TAxis axis,const double &position);		// position relative to current xyz origin
	
	void Add_Point(const TVector3 &pnt);
	
private:
	TAxis								d_axis;
	double								d_position;
	std::vector<TVector3>				d_move_points;
	
	// NOT IMPLEMENTED
	TCommandMoveCube(const TCommandMoveCube&);
	TCommandMoveCube& operator=(const TCommandMoveCube&);
};

#endif
