/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <assert.h>

#include "command_feature.h"
#include "command_sequence.h"

TCommandSequence::TCommandSequence(void)
{
}

TCommandSequence::~TCommandSequence(void)
{
}
bool TCommandSequence::Is_Sequence_Complete(void) const
{
	if(d_current_command == d_commands.end())
	{
		return true;
	}
	
	return false;
}

int TCommandSequence::Count(void) const
{
	return static_cast<int>(d_commands.size());
}

TCommand * TCommandSequence::Get_Next_Command(
	bool								*valid) const
{
	TCommand							*command;
	
	assert(valid);
	
	if(d_current_command == d_commands.end())
	{
		*valid = false;
		return 0;
	}
	
	command = (*d_current_command);
	
	*valid = true;
	
	++d_current_command;
	return command;
}

TCommandFeature * TCommandSequence::Get_Feature_Command(
	const int							memory_id) const
{
	std::vector<TCommand*>::const_reverse_iterator iter;
	TCommandFeature						*command_feature(0);
	
	if(memory_id < 0)
	{
		return 0;
	}
	
	// the last feature added with a specific memory_id is returned
	for(iter = d_commands.rbegin();iter != d_commands.rend();++iter)
	{
		switch((*iter)->Type())
		{
			case TCommand::COMMAND_MEASURE_PLANE:
			case TCommand::COMMAND_MEASURE_LINE:
			case TCommand::COMMAND_MEASURE_POINT:
			case TCommand::COMMAND_MEASURE_SPHERE:
			case TCommand::COMMAND_MEASURE_CIRCLE:
				
				command_feature = reinterpret_cast<TCommandFeature*>(*iter);
				
				if(command_feature->Memory_Id() == memory_id)
				{
					return command_feature;
				}

				break;
				
			case TCommand::COMMAND_NULL:
			case TCommand::COMMAND_ALIGN:
			case TCommand::COMMAND_MODAL_MODE:
			case TCommand::COMMAND_MODAL_PROMPT:
			case TCommand::COMMAND_MODAL_SYNC:
			case TCommand::COMMAND_MOVE:
			case TCommand::COMMAND_MOVE_CUBE:
			case TCommand::COMMAND_DIMENSION:
			case TCommand::COMMAND_QUERY_TOOL:
			case TCommand::COMMAND_SET_TOOL:
				break;
		}
	}
	
	return 0;
}

void TCommandSequence::Start_Sequence(void)
{
	TCommandFeature						* command_feature;
	std::vector<TCommand*>::iterator	iter;
	
	d_current_command = d_commands.begin();
	
	for(iter = d_commands.begin();iter != d_commands.end();++iter)
	{
		switch((*iter)->Type())
		{
			case TCommand::COMMAND_NULL:
			case TCommand::COMMAND_ALIGN:
			case TCommand::COMMAND_MODAL_MODE:
			case TCommand::COMMAND_MODAL_PROMPT:
			case TCommand::COMMAND_MODAL_SYNC:
			case TCommand::COMMAND_MOVE:
			case TCommand::COMMAND_MOVE_CUBE:
			case TCommand::COMMAND_DIMENSION:
			case TCommand::COMMAND_QUERY_TOOL:
			case TCommand::COMMAND_SET_TOOL:
				break;
				
			case TCommand::COMMAND_MEASURE_PLANE:
			case TCommand::COMMAND_MEASURE_LINE:
			case TCommand::COMMAND_MEASURE_POINT:
			case TCommand::COMMAND_MEASURE_SPHERE:
			case TCommand::COMMAND_MEASURE_CIRCLE:
				
				command_feature = reinterpret_cast<TCommandFeature*>(*iter);
				command_feature->Reset_Actual();
				
				break;
		}
	}
}

void TCommandSequence::Add_Command(
	TCommand							* const command)
{
	int									index;
	
	assert(command);

	if(d_commands.size())
	{
		index = d_current_command - d_commands.begin();
	}
	else
	{
		index = 0;
	}
	
	d_commands.push_back(command);
	
	d_current_command = d_commands.begin() + index;
}

void TCommandSequence::Delete_Commands(void)
{
	while(d_commands.size())
	{
		delete d_commands[0];
		d_commands.erase(d_commands.begin());
	}
}

