/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COMMANDSEQUENCEHEADERFILE
#define COMMANDSEQUENCEHEADERFILE

#include <vector>

#include "../../../core/vector3.h"

#include "command.h"
#include "command_feature.h"

class TCommandSequence
{
public:
// CREATORS
	TCommandSequence(void);
	~TCommandSequence(void);
	
// ACCESSORS
	bool Is_Sequence_Complete(void) const;
	int Count(void) const;
	
	TCommand * Get_Next_Command(bool *command_valid) const;
	TCommandFeature * Get_Feature_Command(const int memory_id) const;

// MANIPULATORS
	void Start_Sequence(void);
	
	void Add_Command(TCommand * const command);
	void Delete_Commands(void);
	
private:
	
	std::vector<TCommand*>				d_commands;
	mutable std::vector<TCommand*>::iterator d_current_command;
	
	
// NOT IMPLEMENTED
	TCommandSequence(const TCommandSequence&);
	TCommandSequence& operator=(const TCommandSequence&);
	
};

#endif
