/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef COORDINATEDISPLAYWIDGETHEADERFILE
#define COORDINATEDISPLAYWIDGETHEADERFILE

#include <QWidget>

#include "../../../core/vector3.h"

class TCoordinateWidget;

class TCoordinateDisplayWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TCoordinateDisplayWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TCoordinateDisplayWidget(void);

// ACCESSORS
	TVector3 Get_XYZ(void) const;

// MANIPULATORS
	void Set_X(const double &value);
	void Set_Y(const double &value);
	void Set_Z(const double &value);
	void Set_XYZ(const TVector3 &xyz);

signals:

private slots:

private:
	TCoordinateWidget					*d_x_value_label;
	TCoordinateWidget					*d_y_value_label;
	TCoordinateWidget					*d_z_value_label;

// NOT IMPLEMENTED
	TCoordinateDisplayWidget(const TCoordinateDisplayWidget&);
	TCoordinateDisplayWidget& operator=(const TCoordinateDisplayWidget&);
};

#endif
