/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef EXERCISEDIALOGHEADERFILE
#define EXERCISEDIALOGHEADERFILE

#include <QDialog>
#include <vector>

#include "../../../core/vector3.h"

#include "driver.h"

class QComboBox;
class QLineEdit;
class QPushButton;
class QToolButton;
class QSpinBox;
class QPlainTextEdit;
class QCloseEvent;

class TExerciseDialog : public QDialog
{
Q_OBJECT

public:
	
// CREATORS
	TExerciseDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	virtual ~TExerciseDialog(void);

// ACCESSORS
	
	std::vector<TDriver::TCommand> Get_Next_Driver_Commands(void);

// MANIPULATORS
	void Reset(const QStringList &tool_list,const QString &active_tool_name = QString());
	void Reset_Tool_Selection(void);
	void Sequence_Canceled(void);

	void Driver_Error(const QString &error,const int severity);

	void Set_Position(const TVector3 &pos);
	void Driver_Sync(const int);

signals:
	void Change_Tool(const QString&);
	
	void Sequence_Start(void);
	void Sequence_Cancel(void);
	void Sequence_End(void);

	void Get_Position(void);
	void Move_Position(const double&, const double&,const double&);		// xyz

private slots:
	void Start(void);
	void Stop(void);
	void Get_Corner1(void);
	void Get_Corner2(void);
	void Move_Corner1(void);
	void Move_Corner2(void);
	void Tool_Selection_Changed(int);

protected:
	virtual void closeEvent(QCloseEvent *event);

private:
	
enum TExerciseSequence
{
	SEQUENCE_SIMPLE = 0,
	SEQUENCE_ELLIPSE,
	SEQUENCE_STARBURST,
	SEQUENCE_ZIGZAG
};

enum TWaitingState
{
	NOT_WAITING = 0,
	WAITING_CORNER1,
	WAITING_CORNER2
};
	
enum TExecutionState
{
	STATE_STOPPED = 0,
	STATE_RUNNING
};

	QPlainTextEdit						*d_log_text;
	QComboBox							*d_pattern_combo;
	QComboBox							*d_active_tool_combo;
	QSpinBox							*d_count_spin;
	QLineEdit							*d_corner_1_x_edit;
	QLineEdit							*d_corner_1_y_edit;
	QLineEdit							*d_corner_1_z_edit;
	QLineEdit							*d_corner_2_x_edit;
	QLineEdit							*d_corner_2_y_edit;
	QLineEdit							*d_corner_2_z_edit;
	QPushButton							*d_close_button;
	QToolButton							*d_get_corner_1_button;
	QToolButton							*d_get_corner_2_button;
	QToolButton							*d_move_corner_1_button;
	QToolButton							*d_move_corner_2_button;
	QPushButton							*d_start_button;
	QPushButton							*d_stop_button;
	
	TWaitingState						d_waiting_state;
	TExecutionState						d_current_state;

	std::vector<TDriver::TCommand>		d_commands;
	
	void Set_State(const TExecutionState);

	void Clear_Log(void);
	void Add_Log_Text(const QString&);


// NOT IMPLEMENTED
	TExerciseDialog(const TExerciseDialog&);
	TExerciseDialog& operator=(const TExerciseDialog&);
};

#endif
