/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////



#include <QApplication>
#include <QGridLayout>
#include <QLabel>
#include <QSpacerItem>
#include <QToolButton>

#include "iconwidget.h"

TIconWidget::TIconWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	QGridLayout							*gridLayout;
	QSpacerItem							*left_hspacer;
	QSpacerItem							*right_hspacer;

	gridLayout = new QGridLayout(this);
	gridLayout->setContentsMargins(0,0,0,0);
	gridLayout->setVerticalSpacing(2);
	
	left_hspacer = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
	gridLayout->addItem(left_hspacer,0,0,1,1);

	d_icon_button = new QToolButton(this);
	d_icon_button->setMinimumSize(64,64);
	d_icon_button->setMaximumSize(64,64);
	d_icon_button->setIconSize(QSize(64,64));
	gridLayout->addWidget(d_icon_button,0,1,1,1);

	right_hspacer = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
	gridLayout->addItem(right_hspacer,0,2,1,1);

	d_text_label = new QLabel(this);
	d_text_label->setAlignment(Qt::AlignCenter);
	gridLayout->addWidget(d_text_label,1,0,1,3);

	connect(d_icon_button,&QToolButton::clicked,this,&TIconWidget::Clicked);
}

TIconWidget::~TIconWidget(void)
{
}

void TIconWidget::Set_Icon(
	const QString						&name)
{
	d_icon_button->setIcon(QIcon(name));
}

void TIconWidget::Set_Text(
	const QString						&text)
{
	d_text_label->setText(text);
}


