/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////



#ifndef ICONWIDGETHEADERFILE
#define ICONWIDGETHEADERFILE

#include <QWidget>

class QLabel;
class QToolButton;

class TIconWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TIconWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TIconWidget(void);

// ACCESSORS

// MANIPULATORS
	void Set_Icon(const QString &name);
	void Set_Text(const QString &text);

signals:
	void Clicked(void);

private slots:

private:
	QLabel								*d_text_label;
	QToolButton							*d_icon_button;

// NOT IMPLEMENTED
	TIconWidget(const TIconWidget&);
	TIconWidget& operator=(const TIconWidget&);
};

#endif
