/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef INFORMATIONWIDGETHEADERFILE
#define INFORMATIONWIDGETHEADERFILE

#include <QFrame>

class QLabel;

class TInformationWidget : public QFrame
{
Q_OBJECT
	
	static const unsigned int			MAXIMUM_ROW_COUNT = 8;

public:

// CREATORS
	TInformationWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TInformationWidget(void);

// ACCESSORS
	int Maximum_Row_Count(void) const {return static_cast<int>(MAXIMUM_ROW_COUNT);}

// MANIPULATORS
	void Set_Name_Text(const int index,const QString &text);
	void Set_Value_Text(const int index,const QString &text);

signals:

private slots:

private:
	QLabel								*d_name_label[MAXIMUM_ROW_COUNT];
	QLabel								*d_value_label[MAXIMUM_ROW_COUNT];

// NOT IMPLEMENTED
	TInformationWidget(const TInformationWidget&);
	TInformationWidget& operator=(const TInformationWidget&);
};

#endif
