/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef INPUTWIDGETHEADERFILE
#define INPUTWIDGETHEADERFILE

#include <QWidget>
#include <vector>

class QLabel;
class QLineEdit;
class QSpacerItem;
class QGridLayout;
class QSpacerItem;
class TInputWidgetItem;

class TInputWidget : public QWidget
{
Q_OBJECT

public:
	
enum TLayoutMode
{
	MODE_LEFT = 0,
	MODE_RIGHT
};

// CREATORS
	TInputWidget(const TLayoutMode mode,const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TInputWidget(void);

// ACCESSORS
	int	Entry_Count(void) const {return d_entry_count;}
	
	QString Entry_Label_Text(const int index) const;
	QString Entry_Item_Text(const int index) const;
	int Entry_Item_Data(const int index) const;
	
// MANIPULATORS
	void Set_Entry_Count(const int count);
	
	void Configure_Entry_As_Text(const int index);
	void Configure_Entry_As_Combo(const int index);
	
	void Set_Entry_Label_Text(const int index,const QString &text);
	void Set_Entry_Item_Text(const int index,const QString &text);
	
	void Clear_Entry_Item_Combo(const int index);
	void Add_Entry_Combo_Item(const int index,const QString &text, const int option_data);
	void Add_Entry_Combo_Items(const int index,const QStringList &options);
	
	void Select_Entry_Item_Combo_Text(const int index,const QString &text);
	void Select_Entry_Item_Combo_Data(const int index,const int option_data);

	void Enable_Entry_Item(const int index,const bool state);
	void Enable_Entry_Items(const bool state);

	void Set_Static_Widget(QWidget * const widget,const int column,const int columns);
	
signals:
	void Selection_Changed_Combo(int,int);		// option index, option data

private slots:
	void Selection_Changed(int);

private:
	
struct TInputEntry
{
	QLabel								*input_label;
	TInputWidgetItem					*input_item;
};

	QGridLayout							*d_entry_layout;
	QSpacerItem							*d_entry_vspacer;

	int									d_entry_count;
	TLayoutMode 						d_layout_mode;

	std::vector<TInputEntry>			d_input_entries;
	QWidget								*d_static_widget_1;
	QWidget								*d_static_widget_2;
	QWidget								*d_static_widget_3;

	
// NOT IMPLEMENTED
	TInputWidget(const TInputWidget&);
	TInputWidget& operator=(const TInputWidget&);
};

#endif
