/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef INPUTWIDGETITEMHEADERFILE
#define INPUTWIDGETITEMHEADERFILE

#include <QWidget>

class QVBoxLayout;
class QComboBox;
class QLineEdit;
class QCheckBox;
//class QStackedWidget;

class TInputWidgetItem : public QWidget
{
Q_OBJECT

public:
	
enum TWidgetType
{
	TYPE_NONE = 0,
	TYPE_TEXT,
	TYPE_COMBO
};

// CREATORS
	TInputWidgetItem(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TInputWidgetItem(void);

// ACCESSORS
	TWidgetType Type(void) const {return d_widget_type;}
	
	QComboBox* Widget_Combo(void) const;
	QLineEdit* Widget_Edit(void) const;
	
// MANIPULATORS
	void Set_Type(const TWidgetType type);

private slots:

private:
	QVBoxLayout							*d_widget_vlayout;
	QComboBox							*d_combo_box;
	QLineEdit							*d_line_edit;
	TWidgetType							d_widget_type;

// NOT IMPLEMENTED
	TInputWidgetItem(const TInputWidgetItem&);
	TInputWidgetItem& operator=(const TInputWidgetItem&);
};

#endif
