/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <QWidget>
#include <QString>

#include "laserinputedit.h"

TLaserInputEdit::TLaserInputEdit(const QWidget *parent)
:QLineEdit(const_cast<QWidget*>(parent))
{
	this->setFocusPolicy(Qt::StrongFocus);
}

TLaserInputEdit::~TLaserInputEdit(void)
{
}

double TLaserInputEdit::Value(void) const
{
	return this->text().toDouble();
}

void TLaserInputEdit::Set_Value(
	const double						&value,
	const int							precision)
{
	bool								prev_state;
	
	prev_state = this->blockSignals(true);
	this->setText(QString("%1").arg(value,0,'f',precision));
	this->blockSignals(prev_state);
}
