/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef LINKDIALOGHEADERFILE
#define LINKDIALOGHEADERFILE

#include <QDialog>

#include "controller.h"

class QWidget;
class QObject;
class QPushButton;
class QLabel;
class QTimer;
class QCloseEvent;

class TOptionEditorWidget;
class TSerialLeitzThread;
class TSocketLeitzThread;
class TLinkFileWidget;


class TLinkDialog : public QDialog
{
    Q_OBJECT
	
public:
	
struct TConnectionDefaults
{
	int									default_connection_method;	// 0 = serial, 1 = ethernet
	QString								default_leitz_address;
	QString								default_leitz_commport;
	int									default_leitz_port;
	QString								default_dc_address;
	int									default_dc_port;
	QString								default_ipp_address;
	int									default_ipp_port;
	QString								default_virtual_address;
	int									default_virtual_port;
};

	
// CREATORS
    TLinkDialog(const QWidget *parent=0,Qt::WindowFlags flags=Qt::WindowFlags());
    ~TLinkDialog(void);
	
// ACCESSORS
	TLinkProtocol::TProtocolType Connection_Protocol(void) const;
	TConnectionDefaults Connection_Defaults(void) const {return d_connection_defaults;}
	
	QString Comm_Port(void) const;
	TLibSerialDeviceEnum::TBaudRate Baud_Rate(void);
	QString Ethernet_Address(void) const;
	int Ethernet_Port(void) const;

// MANIPULATORS
	void Set_Connection_Defaults(const TConnectionDefaults &connection_defaults);
	void Reset(TController::TControllerType controller_type);
	
	
private slots:
	void Accept(void);
	void Option_Changed(int,const QString&);	// index, option text
	
private:
	
	QPushButton							*d_accept_button;
	QPushButton							*d_cancel_button;
	
	TOptionEditorWidget					*d_option_editor;
	
	TController::TControllerType		d_controller_type;
	
	int									d_protocol_method_index;
	int									d_serial_comport_index;
	int									d_serial_baud_index;
	int									d_ethernet_index;
	int									d_ethernet_portnumber_index;
	
	int									d_connection_method;
	TLibSerialDeviceEnum::TBaudRate		d_serial_baudrate;
	QString								d_serial_comport;
	QString								d_ethernet_address;
	int									d_ethernet_port;
	
	TConnectionDefaults					d_connection_defaults;
	
	void Create_Options(void);

	TLibSerialDeviceEnum::TBaudRate Convert_Baudrate_Option(const QString &option_text);
	
// NOT IMPLEMENTED
    TLinkDialog(const TLinkDialog&);
    TLinkDialog& operator=(const TLinkDialog&);
	
};


#endif
