/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#include <QApplication>
#include <QGridLayout>
#include <QSpacerItem>

#include "iconwidget.h"
#include "titlewidget.h"

#include "measurewidget.h"

TMeasureWidget::TMeasureWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	QGridLayout							*widget_layout;
	QSpacerItem							*control_hspacer;
	TTitleWidget						*title_widget;

	widget_layout = new QGridLayout(this);
	widget_layout->setContentsMargins(0,0,0,0);

	title_widget = new TTitleWidget(this);
	widget_layout->addWidget(title_widget,0,0,1,10);

	d_stepgauge_10360_option = new TIconWidget(this);
	d_stepgauge_10360_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_stepgauge_10360_option,1,0,1,1);

	d_stepgauge_b89_option = new TIconWidget(this);
	d_stepgauge_b89_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_stepgauge_b89_option,1,1,1,1);
	
	d_stepgauge_square_option = new TIconWidget(this);
	d_stepgauge_square_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_stepgauge_square_option,1,2,1,1);
	
	d_ballbar_option = new TIconWidget(this);
	d_ballbar_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_ballbar_option,1,3,1,1);
	
	d_ballbar_10360_option = new TIconWidget(this);
	d_ballbar_10360_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_ballbar_10360_option,1,4,1,1);

	d_gaugeblock_option = new TIconWidget(this);
	d_gaugeblock_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_gaugeblock_option,1,5,1,1);
	
	d_ringgauge_option = new TIconWidget(this);
	d_ringgauge_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_ringgauge_option,1,6,1,1);
	
	d_pingauge_option = new TIconWidget(this);
	d_pingauge_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_pingauge_option,1,7,1,1);
	
	d_pftu_option = new TIconWidget(this);
	d_pftu_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_pftu_option,2,0,1,1);

	d_sphere_repeat_option = new TIconWidget(this);
	d_sphere_repeat_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_sphere_repeat_option,2,1,1,1);

	d_point_repeat_option = new TIconWidget(this);
	d_point_repeat_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_point_repeat_option,2,2,1,1);
	
	d_roll_option = new TIconWidget(this);
	d_roll_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_roll_option,2,3,1,1);

	d_laser_option = new TIconWidget(this);
	d_laser_option->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred));
	widget_layout->addWidget(d_laser_option,2,4,1,1);

	control_hspacer = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
	widget_layout->addItem(control_hspacer,1,8,2,1);

	title_widget->Set_Text("Measure");
	
	d_stepgauge_10360_option->Set_Icon(QStringLiteral(":/icon64/stepgauge_10360_icon64.png"));
	d_stepgauge_10360_option->Set_Text(QStringLiteral("Step Gauge\n10360"));
	
	d_stepgauge_b89_option->Set_Icon(QStringLiteral(":/icon64/stepgauge_b89_icon64.png"));
	d_stepgauge_b89_option->Set_Text(QStringLiteral("Step Gauge\nB89.4.1"));
	
	d_stepgauge_square_option->Set_Icon(QStringLiteral(":/icon64/stepgauge_square_icon64.png"));
	d_stepgauge_square_option->Set_Text(QStringLiteral("Step Gauge\nSquare"));
	
	d_ballbar_option->Set_Icon(QStringLiteral(":/icon64/ballbar_icon64.png"));
	d_ballbar_option->Set_Text(QStringLiteral("Ballbar\nB89.4.1"));
	
	d_ballbar_10360_option->Set_Icon(QStringLiteral(":/icon64/ballbar10360_icon64.png"));
	d_ballbar_10360_option->Set_Text(QStringLiteral("Ballbar\n10360"));

	d_gaugeblock_option->Set_Icon(QStringLiteral(":/icon64/gaugeblock_icon64.png"));
	d_gaugeblock_option->Set_Text(QStringLiteral("Gauge Block\n10360"));
	
	d_point_repeat_option->Set_Icon(QStringLiteral(":/icon64/point_repeat_icon64.png"));
	d_point_repeat_option->Set_Text(QStringLiteral("Point\nRepeat"));

	d_sphere_repeat_option->Set_Icon(QStringLiteral(":/icon64/sphere_repeat_icon64.png"));
	d_sphere_repeat_option->Set_Text(QStringLiteral("Sphere\nRepeat Rpt"));
	
	d_pftu_option->Set_Icon(QStringLiteral(":/icon64/pftu_icon64.png"));
	d_pftu_option->Set_Text(QStringLiteral("Sphere\n10360 Pftu"));
	
	d_ringgauge_option->Set_Icon(QStringLiteral(":/icon64/ring_icon64.png"));
	d_ringgauge_option->Set_Text(QStringLiteral("Ring Gauge"));
	
	d_pingauge_option->Set_Icon(QStringLiteral(":/icon64/pin_icon64.png"));
	d_pingauge_option->Set_Text(QStringLiteral("Pin Gauge"));
	
	d_roll_option->Set_Icon(QStringLiteral(":/icon64/roll_icon64.png"));
	d_roll_option->Set_Text(QStringLiteral("Roll"));

	d_laser_option->Set_Icon(QStringLiteral(":/icon64/laser_icon64.png"));
	d_laser_option->Set_Text(QStringLiteral("Laser"));

	connect(d_stepgauge_10360_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Stepgauge_10360);
	connect(d_stepgauge_b89_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Stepgauge_B89);
	connect(d_stepgauge_square_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Stepgauge_Square);
	connect(d_ballbar_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Ballbar);
	connect(d_ballbar_10360_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Ballbar_10360);
	connect(d_gaugeblock_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Gaugeblock);
	connect(d_pftu_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Sphere_Pftu);
	connect(d_ringgauge_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Ringgauge);
	connect(d_pingauge_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Pingauge);
	connect(d_sphere_repeat_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Sphere_Repeat);
	connect(d_point_repeat_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Point_Repeat);
	connect(d_roll_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Roll);
	connect(d_laser_option,&TIconWidget::Clicked,this,&TMeasureWidget::Measure_Laser);
}

TMeasureWidget::~TMeasureWidget(void)
{
}

void TMeasureWidget::Enable_Measure_Option(
	const bool							state)
{
	d_stepgauge_10360_option->setEnabled(state);
	d_stepgauge_b89_option->setEnabled(state);
	d_stepgauge_square_option->setEnabled(state);
	d_ballbar_option->setEnabled(state);
	d_ballbar_10360_option->setEnabled(state);
	d_gaugeblock_option->setEnabled(state);
	d_pftu_option->setEnabled(state);
	d_ringgauge_option->setEnabled(state);
	d_pingauge_option->setEnabled(state);
	d_sphere_repeat_option->setEnabled(state);
	d_point_repeat_option->setEnabled(state);
	d_roll_option->setEnabled(state);
	d_laser_option->setEnabled(state);
}


