/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////



#ifndef MEASUREWIDGETHEADERFILE
#define MEASUREWIDGETHEADERFILE

#include <QWidget>

class TIconWidget;

class TMeasureWidget : public QWidget
{
Q_OBJECT

public:


// CREATORS
	TMeasureWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TMeasureWidget(void);

// ACCESSORS
	
// MANIPULATORS
	void Enable_Measure_Option(const bool state);


signals:
	void Measure_Stepgauge_10360(void);
	void Measure_Stepgauge_B89(void);
	void Measure_Stepgauge_Square(void);
	void Measure_Ballbar(void);
	void Measure_Ballbar_10360(void);
	void Measure_Gaugeblock(void);
	void Measure_Point_Repeat(void);
	void Measure_Sphere_Repeat(void);
	void Measure_Sphere_Pftu(void);
	void Measure_Ringgauge(void);
	void Measure_Pingauge(void);
	void Measure_Roll(void);
	void Measure_Laser(void);

private slots:
	

private:
	TIconWidget							*d_stepgauge_10360_option;
	TIconWidget							*d_stepgauge_b89_option;
	TIconWidget							*d_stepgauge_square_option;
	TIconWidget							*d_ballbar_option;
	TIconWidget							*d_ballbar_10360_option;
	TIconWidget							*d_gaugeblock_option;
	TIconWidget							*d_point_repeat_option;
	TIconWidget							*d_sphere_repeat_option;
	TIconWidget							*d_pftu_option;
	TIconWidget							*d_ringgauge_option;
	TIconWidget							*d_pingauge_option;
	TIconWidget							*d_roll_option;
	TIconWidget							*d_laser_option;

// NOT IMPLEMENTED
	TMeasureWidget(const TMeasureWidget&);
	TMeasureWidget& operator=(const TMeasureWidget&);
};

#endif
