/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QSpacerItem>

#include "nameeditdialog.h"

TNameEditDialog::TNameEditDialog(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QDialog(const_cast<QWidget*>(parent),flags)
{
	QGridLayout							*dialog_layout;
	QHBoxLayout							*button_hlayout;
	QPushButton							*cancel_button;
	QSpacerItem							*button_hspacer;


	this->resize(410,100);

	dialog_layout = new QGridLayout(this);

	d_name_label = new QLabel(this);
	dialog_layout->addWidget(d_name_label,0,0,1,1);

	d_name_edit = new QLineEdit(this);
	dialog_layout->addWidget(d_name_edit,0,1,1,1);

	button_hlayout = new QHBoxLayout();

	button_hspacer = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
	button_hlayout->addItem(button_hspacer);

	cancel_button = new QPushButton(this);
	cancel_button->setAutoDefault(false);
	button_hlayout->addWidget(cancel_button);

	d_accept_button = new QPushButton(this);
	button_hlayout->addWidget(d_accept_button);
	dialog_layout->addLayout(button_hlayout,1,0,1,2);

	this->setWindowTitle(QStringLiteral("Name Edit"));
	
	d_name_label->setText(QStringLiteral("TextLabel"));
	cancel_button->setText(QStringLiteral("Cancel"));
	d_accept_button->setText(QStringLiteral("Accept"));
	
	connect(cancel_button,&QPushButton::clicked,this,&TNameEditDialog::reject);
	connect(d_accept_button,&QPushButton::clicked,this,&TNameEditDialog::accept);

	connect(d_name_edit,&QLineEdit::textEdited,this,&TNameEditDialog::Name_Changed);
	
}

TNameEditDialog::~TNameEditDialog(void)
{
}

QString TNameEditDialog::Name(void) const
{
	return d_name_edit->text();
}

void TNameEditDialog::Reset(
	const QString						&dialog_title,
	const QString						&parameter_name,
	const QStringList					&existing_names)
{
	d_existing_names = existing_names;

	this->setWindowTitle(dialog_title);
	d_name_label->setText(parameter_name);
	d_name_edit->setText(QString());
	
	d_accept_button->setEnabled(false);
}

void TNameEditDialog::Name_Changed(
	const QString						&name)
{
	if(name.length())
	{
		d_accept_button->setEnabled(!d_existing_names.contains(name));
		
		return;
	}
	
	d_accept_button->setEnabled(false);
}

