/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef PATHPOINTHEADERFILE
#define PATHPOINTHEADERFILE

#include "../../../core/vector3.h"

class TPathPoint
{
public:
enum TPathType
{
	MOVE_POINT = 0,
	TOUCH_POINT
};
	
// CREATORS
	TPathPoint(void);
	TPathPoint(const TPathPoint&);
	TPathPoint& operator=(const TPathPoint&);
	~TPathPoint(void);
	
// ACCESSORS
	int Id(void) const {return d_id;}
	TPathType Type(void) const {return d_type;}
	TVector3 XYZ(void) const {return d_xyz;}
	TVector3 IJK(void) const {return d_ijk;}
	
	
// MANIPULATORS
	void Set_Id(const int id) {d_id = id;}
	void Set_Type(const TPathType type) {d_type = type;}
	
	void Set_XYZ(const TVector3 &pnt) {d_xyz = pnt;}
	void Set_X(const double &d) {d_xyz.x = d;}
	void Set_Y(const double &d) {d_xyz.y = d;}
	void Set_Z(const double &d) {d_xyz.z = d;}
	
	void Set_IJK(const TVector3 &vec) {d_ijk = vec;}
	void Set_I(const double &d) {d_ijk.i = d;}
	void Set_J(const double &d) {d_ijk.j = d;}
	void Set_K(const double &d) {d_ijk.k = d;}

private:
	
	int									d_id;
	TPathType							d_type;
	TVector3							d_xyz;
	TVector3							d_ijk;
	
// NOT IMPLEMENTED
};

#endif
