/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFrame>
#include <QGridLayout>
#include <QLCDNumber>
#include <QLabel>

#include "pointcountwidget.h"

static const int						g_lcd_fixed_width(120);

TPointCountWidget::TPointCountWidget(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QWidget(const_cast<QWidget*>(parent),flags)
{
	QFrame								*separator_hline;
	QGridLayout							*widget_layout;
	QLabel								*actual_label;
	QLabel								*nominal_label;

	widget_layout = new QGridLayout(this);
	widget_layout->setSpacing(0);
	widget_layout->setContentsMargins(0, 0, 0, 0);
	
	actual_label = new QLabel(this);
	widget_layout->addWidget(actual_label,0,0,1,1);
	
	d_actual_count_lcd = new QLCDNumber(this);
	d_actual_count_lcd->setDigitCount(4);
	d_actual_count_lcd->setFrameShape(QFrame::NoFrame);		// NoFrame, Box
	d_actual_count_lcd->setFixedWidth(g_lcd_fixed_width);
	widget_layout->addWidget(d_actual_count_lcd,0,1,1,1);

	separator_hline = new QFrame(this);
	separator_hline->setFrameShape(QFrame::HLine);
	separator_hline->setFrameShadow(QFrame::Sunken);
	widget_layout->addWidget(separator_hline,1,0,1,2);
	
	nominal_label = new QLabel(this);
	widget_layout->addWidget(nominal_label,2,0,1,1);

	d_nominal_count_lcd = new QLCDNumber(this);
	d_nominal_count_lcd->setDigitCount(4);
	d_nominal_count_lcd->setFrameShape(QFrame::NoFrame);	// NoFrame, Box
	d_nominal_count_lcd->setFixedWidth(g_lcd_fixed_width);
	widget_layout->addWidget(d_nominal_count_lcd,2,1,1,1);
	
	actual_label->setText(QStringLiteral("Measured: "));
	nominal_label->setText(QStringLiteral("Expected: "));
}

TPointCountWidget::~TPointCountWidget(void)
{
}

int TPointCountWidget::Nominal_Point_Count(void) const
{
	return d_nominal_count_lcd->intValue();
}

int TPointCountWidget::Actual_Point_Count(void) const
{
	return d_actual_count_lcd->intValue();
}

void TPointCountWidget::Set_Nominal_Point_Count(
	const int							count)
{
	d_nominal_count_lcd->display(count);
}

void TPointCountWidget::Set_Actual_Point_Count(
	const int							count)
{
	d_actual_count_lcd->display(count);
}


