/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef POINTCOUNTWIDGETHEADERFILE
#define POINTCOUNTWIDGETHEADERFILE

#include <QWidget>

class QLCDNumber;

class TPointCountWidget : public QWidget
{
Q_OBJECT

public:

// CREATORS
	TPointCountWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TPointCountWidget(void);

// ACCESSORS
	int Nominal_Point_Count(void) const;
	int Actual_Point_Count(void) const;

// MANIPULATORS
	void Set_Nominal_Point_Count(const int count);
	void Set_Actual_Point_Count(const int count);

signals:

private slots:

private:
	QLCDNumber							*d_actual_count_lcd;
	QLCDNumber							*d_nominal_count_lcd;

// NOT IMPLEMENTED
	TPointCountWidget(const TPointCountWidget&);
	TPointCountWidget& operator=(const TPointCountWidget&);
};

#endif
