/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef REPORTWIDGETHEADERFILE
#define REPORTWIDGETHEADERFILE

#include <QWidget>

class QLabel;

class TIconWidget;
class TMeasureOutputDialog;
class TValidationDialog;

class TReportWidget : public QWidget
{
	Q_OBJECT
	
public:

struct TOutputSettings
{
	QString								output_relative_path;
	QString								output_absolute_path;
	bool								use_relative_path;
};
	
	// CREATORS
	TReportWidget(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TReportWidget(void);
	
	// ACCESSORS
	TReportWidget::TOutputSettings Output_Settings(void) const;
	
	QString Output_Path(void) const;	// always returns a valid path regardless of settings
	
	// MANIPULATORS
	void Set_Output_Settings(const QString &data_path,const TReportWidget::TOutputSettings &settings);
	void Enable_Options(const bool state);
	
signals:

private slots:
	void Change_Output_Settings(void);
	void Open_Report(void);
	void Validation_Test(void);
	
private:
	
	TIconWidget							*d_output_settings_option;
	TIconWidget							*d_report_option;
	TIconWidget							*d_validation_option;
	TMeasureOutputDialog				*d_settings_output_dialog;
	TValidationDialog					*d_validation_dialog;

	QString								d_application_path;
	QString								d_data_path;
	TOutputSettings						d_output_settings;
		
	// NOT IMPLEMENTED
	TReportWidget(const TReportWidget&);
	TReportWidget& operator=(const TReportWidget&);
};

#endif
