/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#include <QApplication>
#include <QFrame>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QSpacerItem>
#include <QTreeWidget>
#include <QTreeWidgetItem>

#include "settings_artifactdialog.h"

TSettingsArtifactDialog::TSettingsArtifactDialog(
	const QWidget						*parent,
	const Qt::WindowFlags				flags)
:QDialog(const_cast<QWidget*>(parent),flags)
{
	QFrame								*separator_hline;
	QGridLayout							*dialog_layout;
	QHBoxLayout							*button_hlayout;
	QPushButton							*cancel_button;
	QSpacerItem							*button_hspacer;
	QTreeWidgetItem						*header_item;
	QTreeWidgetItem						*stepgauge_item;
	QTreeWidgetItem						*stepgauge_plane_item;
	QTreeWidgetItem						*stepgauge_line_item;
	QTreeWidgetItem						*stepgauge_point_item;
	QTreeWidgetItem						*stepgauge_general_item;
	QTreeWidgetItem						*gaugeblock_item;
	QTreeWidgetItem						*gaugeblock_plane_item;
	QTreeWidgetItem						*gaugeblock_general_item;
	QTreeWidgetItem						*ballbar_b89_item;
	QTreeWidgetItem						*ballbar_b89_general_item;
	QTreeWidgetItem						*ballbar_10360_item;
	QTreeWidgetItem						*ballbar_10360_general_item;
	QTreeWidgetItem						*ringgauge_item;
	QTreeWidgetItem						*ringgauge_circle_item;
	QTreeWidgetItem						*ringgauge_plane_item;
	QTreeWidgetItem						*ringgauge_general_item;
	QTreeWidgetItem						*pingauge_item;
	QTreeWidgetItem						*pingauge_circle_item;
	QTreeWidgetItem						*pingauge_plane_item;
	QTreeWidgetItem						*pingauge_general_item;
	QTreeWidgetItem						*point_repeat_item;
	QTreeWidgetItem						*point_repeat_general_item;
	QTreeWidgetItem						*roll_item;
	QTreeWidgetItem						*roll_general_item;
	QTreeWidgetItem						*calibration_sphere_item;
	QTreeWidgetItem						*calibration_sphere_general_item;
	static const int					DIALOG_WIDTH(501);
	
	this->resize(DIALOG_WIDTH,451);

	dialog_layout = new QGridLayout(this);

	d_tree_widget = new QTreeWidget(this);
	
	header_item = d_tree_widget->headerItem();
	header_item->setText(0,QStringLiteral("Setting"));
	header_item->setText(1,QStringLiteral("Value"));

	stepgauge_item = new QTreeWidgetItem(d_tree_widget);
	stepgauge_item->setText(0,QStringLiteral("Step Gauge Checkmaster"));
	
	stepgauge_plane_item = new QTreeWidgetItem(stepgauge_item);
	stepgauge_plane_item->setText(0,QStringLiteral("Plane"));
	
	stepgauge_line_item = new QTreeWidgetItem(stepgauge_item);
	stepgauge_line_item->setText(0,QStringLiteral("Line"));
	
	stepgauge_point_item = new QTreeWidgetItem(stepgauge_item);
	stepgauge_point_item->setText(0,QStringLiteral("Point"));
	
	stepgauge_general_item = new QTreeWidgetItem(stepgauge_item);
	stepgauge_general_item->setText(0,QStringLiteral("General"));

	d_sg_checkmaster_pln_start_x_item = new QTreeWidgetItem(stepgauge_plane_item);
	d_sg_checkmaster_pln_start_x_item->setText(0,QStringLiteral("X Start Offset"));
	d_sg_checkmaster_pln_start_x_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_checkmaster_pln_end_x_item = new QTreeWidgetItem(stepgauge_plane_item);
	d_sg_checkmaster_pln_end_x_item->setText(0,QStringLiteral("X End Offset"));
	d_sg_checkmaster_pln_end_x_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_checkmaster_pln_start_y_item = new QTreeWidgetItem(stepgauge_plane_item);
	d_sg_checkmaster_pln_start_y_item->setText(0,QStringLiteral("Y Start"));
	d_sg_checkmaster_pln_start_y_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_checkmaster_pln_end_y_item = new QTreeWidgetItem(stepgauge_plane_item);
	d_sg_checkmaster_pln_end_y_item->setText(0,QStringLiteral("Y End"));
	d_sg_checkmaster_pln_end_y_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_checkmaster_ln_start_x_item = new QTreeWidgetItem(stepgauge_line_item);
	d_sg_checkmaster_ln_start_x_item->setText(0,QStringLiteral("X Start Offset"));
	d_sg_checkmaster_ln_start_x_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_checkmaster_ln_end_x_item = new QTreeWidgetItem(stepgauge_line_item);
	d_sg_checkmaster_ln_end_x_item->setText(0,QStringLiteral("X End Offset"));
	d_sg_checkmaster_ln_end_x_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_checkmaster_ln_z_item = new QTreeWidgetItem(stepgauge_line_item);
	d_sg_checkmaster_ln_z_item->setText(0,QStringLiteral("Z Position"));
	d_sg_checkmaster_ln_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	d_sg_checkmaster_pnt_y_item = new QTreeWidgetItem(stepgauge_point_item);
	d_sg_checkmaster_pnt_y_item->setText(0,QStringLiteral("Y Position"));
	d_sg_checkmaster_pnt_y_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	d_sg_checkmaster_pnt_z_item = new QTreeWidgetItem(stepgauge_point_item);
	d_sg_checkmaster_pnt_z_item->setText(0,QStringLiteral("Z Position"));
	d_sg_checkmaster_pnt_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_checkmaster_clear_z_item = new QTreeWidgetItem(stepgauge_general_item);
	d_sg_checkmaster_clear_z_item->setText(0,QStringLiteral("Clear Z"));
	d_sg_checkmaster_clear_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	
	stepgauge_item = new QTreeWidgetItem(d_tree_widget);
	stepgauge_item->setText(0,QStringLiteral("Step Gauge Webber"));
	
	stepgauge_general_item = new QTreeWidgetItem(stepgauge_item);
	stepgauge_general_item->setText(0,QStringLiteral("General"));
	
	
	d_sg_webber_clear_z_item = new QTreeWidgetItem(stepgauge_general_item);
	d_sg_webber_clear_z_item->setText(0,QStringLiteral("Clear Z"));
	d_sg_webber_clear_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	stepgauge_item = new QTreeWidgetItem(d_tree_widget);
	stepgauge_item->setText(0,QStringLiteral("Step Gauge Koba"));
	
	stepgauge_plane_item = new QTreeWidgetItem(stepgauge_item);
	stepgauge_plane_item->setText(0,QStringLiteral("Plane"));
	
	stepgauge_line_item = new QTreeWidgetItem(stepgauge_item);
	stepgauge_line_item->setText(0,QStringLiteral("Line"));
	
	stepgauge_point_item = new QTreeWidgetItem(stepgauge_item);
	stepgauge_point_item->setText(0,QStringLiteral("Point"));
	
	stepgauge_general_item = new QTreeWidgetItem(stepgauge_item);
	stepgauge_general_item->setText(0,QStringLiteral("General"));
	
	d_sg_koba_pln_start_x_item = new QTreeWidgetItem(stepgauge_plane_item);
	d_sg_koba_pln_start_x_item->setText(0,QStringLiteral("X Start Offset"));
	d_sg_koba_pln_start_x_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_koba_pln_end_x_item = new QTreeWidgetItem(stepgauge_plane_item);
	d_sg_koba_pln_end_x_item->setText(0,QStringLiteral("X End Offset"));
	d_sg_koba_pln_end_x_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_koba_pln_start_y_item = new QTreeWidgetItem(stepgauge_plane_item);
	d_sg_koba_pln_start_y_item->setText(0,QStringLiteral("Y Start"));
	d_sg_koba_pln_start_y_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_koba_pln_end_y_item = new QTreeWidgetItem(stepgauge_plane_item);
	d_sg_koba_pln_end_y_item->setText(0,QStringLiteral("Y End"));
	d_sg_koba_pln_end_y_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_koba_ln_start_x_item = new QTreeWidgetItem(stepgauge_line_item);
	d_sg_koba_ln_start_x_item->setText(0,QStringLiteral("X Start Offset"));
	d_sg_koba_ln_start_x_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_koba_ln_end_x_item = new QTreeWidgetItem(stepgauge_line_item);
	d_sg_koba_ln_end_x_item->setText(0,QStringLiteral("X End Offset"));
	d_sg_koba_ln_end_x_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_koba_ln_z_item = new QTreeWidgetItem(stepgauge_line_item);
	d_sg_koba_ln_z_item->setText(0,QStringLiteral("Z Position"));
	d_sg_koba_ln_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_koba_pnt_y_item = new QTreeWidgetItem(stepgauge_point_item);
	d_sg_koba_pnt_y_item->setText(0,QStringLiteral("Y Position"));
	d_sg_koba_pnt_y_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_koba_pnt_z_item = new QTreeWidgetItem(stepgauge_point_item);
	d_sg_koba_pnt_z_item->setText(0,QStringLiteral("Z Position"));
	d_sg_koba_pnt_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_sg_koba_clear_probe_item = new QTreeWidgetItem(stepgauge_general_item);
	d_sg_koba_clear_probe_item->setText(0,QStringLiteral("Clear Probe"));
	d_sg_koba_clear_probe_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	
	gaugeblock_item = new QTreeWidgetItem(d_tree_widget);
	gaugeblock_item->setText(0,QStringLiteral("Gauge Block"));
	
	gaugeblock_plane_item = new QTreeWidgetItem(gaugeblock_item);
	gaugeblock_plane_item->setText(0,QStringLiteral("Plane"));
	
	gaugeblock_general_item = new QTreeWidgetItem(gaugeblock_item);
	gaugeblock_general_item->setText(0,QStringLiteral("General"));

	d_gaugeblock_pnt_y_item = new QTreeWidgetItem(gaugeblock_plane_item);
	d_gaugeblock_pnt_y_item->setText(0,QStringLiteral("Y Center"));
	d_gaugeblock_pnt_y_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_gaugeblock_pnt_z_item = new QTreeWidgetItem(gaugeblock_plane_item);
	d_gaugeblock_pnt_z_item->setText(0,QStringLiteral("Z Center"));
	d_gaugeblock_pnt_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_gaugeblock_pnt_spacing_item = new QTreeWidgetItem(gaugeblock_plane_item);
	d_gaugeblock_pnt_spacing_item->setText(0,QStringLiteral("Point Spacing"));
	d_gaugeblock_pnt_spacing_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_gaugeblock_clear_z_item = new QTreeWidgetItem(gaugeblock_general_item);
	d_gaugeblock_clear_z_item->setText(0,QStringLiteral("Clear Z"));
	d_gaugeblock_clear_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	ballbar_b89_item = new QTreeWidgetItem(d_tree_widget);
	ballbar_b89_item->setText(0,QStringLiteral("BallBar B89.4.1"));
	
	ballbar_b89_general_item = new QTreeWidgetItem(ballbar_b89_item);
	ballbar_b89_general_item->setText(0,QStringLiteral("General"));
	
	d_ballbar_b89_clear_distance_item = new QTreeWidgetItem(ballbar_b89_general_item);
	d_ballbar_b89_clear_distance_item->setText(0,QStringLiteral("Clear Distance"));
	d_ballbar_b89_clear_distance_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_ballbar_b89_avoidance_item = new QTreeWidgetItem(ballbar_b89_general_item);
	d_ballbar_b89_avoidance_item->setText(0,QStringLiteral("Stem Avoidance Angle"));
	d_ballbar_b89_avoidance_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	ballbar_10360_item = new QTreeWidgetItem(d_tree_widget);
	ballbar_10360_item->setText(0,QStringLiteral("BallBar 10360"));
	
	ballbar_10360_general_item = new QTreeWidgetItem(ballbar_10360_item);
	ballbar_10360_general_item->setText(0,QStringLiteral("General"));
	
	d_ballbar_10360_clear_distance_item = new QTreeWidgetItem(ballbar_10360_general_item);
	d_ballbar_10360_clear_distance_item->setText(0,QStringLiteral("Clear Distance"));
	d_ballbar_10360_clear_distance_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_ballbar_10360_sphere_points_item = new QTreeWidgetItem(ballbar_10360_general_item);
	d_ballbar_10360_sphere_points_item->setText(0,QStringLiteral("Sphere Points"));
	d_ballbar_10360_sphere_points_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	ringgauge_item = new QTreeWidgetItem(d_tree_widget);
	ringgauge_item->setText(0,QStringLiteral("Ring Gauge"));
	
	ringgauge_plane_item = new QTreeWidgetItem(ringgauge_item);
	ringgauge_plane_item->setText(0,QStringLiteral("Plane"));

	ringgauge_circle_item = new QTreeWidgetItem(ringgauge_item);
	ringgauge_circle_item->setText(0,QStringLiteral("Circle"));
	
	ringgauge_general_item = new QTreeWidgetItem(ringgauge_item);
	ringgauge_general_item->setText(0,QStringLiteral("General"));

	d_ringgauge_pln_offset_item = new QTreeWidgetItem(ringgauge_plane_item);
	d_ringgauge_pln_offset_item->setText(0,QStringLiteral("Plane Offset"));
	d_ringgauge_pln_offset_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_ringgauge_cir_z_item = new QTreeWidgetItem(ringgauge_circle_item);
	d_ringgauge_cir_z_item->setText(0,QStringLiteral("Measurement Position Z"));
	d_ringgauge_cir_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	d_ringgauge_clear_z_item = new QTreeWidgetItem(ringgauge_general_item);
	d_ringgauge_clear_z_item->setText(0,QStringLiteral("Clear Z"));
	d_ringgauge_clear_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	pingauge_item = new QTreeWidgetItem(d_tree_widget);
	pingauge_item->setText(0,QStringLiteral("Pin Gauge"));
	
	pingauge_plane_item = new QTreeWidgetItem(pingauge_item);
	pingauge_plane_item->setText(0,QStringLiteral("Plane"));
	
	pingauge_circle_item = new QTreeWidgetItem(pingauge_item);
	pingauge_circle_item->setText(0,QStringLiteral("Circle"));
	
	pingauge_general_item = new QTreeWidgetItem(pingauge_item);
	pingauge_general_item->setText(0,QStringLiteral("General"));
	
	d_pingauge_pln_offset_item = new QTreeWidgetItem(pingauge_plane_item);
	d_pingauge_pln_offset_item->setText(0,QStringLiteral("Plane Offset"));
	d_pingauge_pln_offset_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_pingauge_cir_z_item = new QTreeWidgetItem(pingauge_circle_item);
	d_pingauge_cir_z_item->setText(0,QStringLiteral("Measurement Position Z"));
	d_pingauge_cir_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	d_pingauge_clear_z_item = new QTreeWidgetItem(pingauge_general_item);
	d_pingauge_clear_z_item->setText(0,QStringLiteral("Clear Z"));
	d_pingauge_clear_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	point_repeat_item = new QTreeWidgetItem(d_tree_widget);
	point_repeat_item->setText(0,QStringLiteral("Point Repeat"));
	
	point_repeat_general_item = new QTreeWidgetItem(point_repeat_item);
	point_repeat_general_item->setText(0,QStringLiteral("General"));
	
	d_plane_sample_radius_item = new QTreeWidgetItem(point_repeat_general_item);
	d_plane_sample_radius_item->setText(0,QStringLiteral("Plane Sample Radius"));
	d_plane_sample_radius_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);
	
	roll_item = new QTreeWidgetItem(d_tree_widget);
	roll_item->setText(0,QStringLiteral("Roll"));

	roll_general_item = new QTreeWidgetItem(roll_item);
	roll_general_item->setText(0,QStringLiteral("General"));

	d_roll_clear_z_item = new QTreeWidgetItem(roll_general_item);
	d_roll_clear_z_item->setText(0,QStringLiteral("Clear Z"));
	d_roll_clear_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	d_roll_sphere_points_item = new QTreeWidgetItem(roll_general_item);
	d_roll_sphere_points_item->setText(0,QStringLiteral("Sphere Points"));
	d_roll_sphere_points_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	calibration_sphere_item = new QTreeWidgetItem(d_tree_widget);
	calibration_sphere_item->setText(0,QStringLiteral("Tool Calibration"));

	calibration_sphere_general_item = new QTreeWidgetItem(calibration_sphere_item);
	calibration_sphere_general_item->setText(0,QStringLiteral("General"));

	d_calibration_sphere_clear_z_item = new QTreeWidgetItem(calibration_sphere_general_item);
	d_calibration_sphere_clear_z_item->setText(0,QStringLiteral("Clear Z"));
	d_calibration_sphere_clear_z_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	d_calibration_sphere_points_item = new QTreeWidgetItem(calibration_sphere_general_item);
	d_calibration_sphere_points_item->setText(0,QStringLiteral("Sphere Points"));
	d_calibration_sphere_points_item->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEditable|Qt::ItemIsUserCheckable|Qt::ItemIsEnabled);

	dialog_layout->addWidget(d_tree_widget,0,0,1,1);
	
	separator_hline = new QFrame(this);
	separator_hline->setFrameShape(QFrame::HLine);
	separator_hline->setFrameShadow(QFrame::Sunken);
	dialog_layout->addWidget(separator_hline,1,0,1,1);
	
	button_hlayout = new QHBoxLayout();
	
	button_hspacer = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Minimum);
	button_hlayout->addItem(button_hspacer);
	
	cancel_button = new QPushButton(this);
	cancel_button->setAutoDefault(false);
	button_hlayout->addWidget(cancel_button);
	
	d_apply_button = new QPushButton(this);
	d_apply_button->setAutoDefault(false);
	button_hlayout->addWidget(d_apply_button);

	dialog_layout->addLayout(button_hlayout,2,0,1,1);
	
	d_tree_widget->setColumnWidth(0,DIALOG_WIDTH / 2);

	this->setWindowTitle(QStringLiteral("Artifact Settings"));

	cancel_button->setText(QStringLiteral("Cancel"));
	d_apply_button->setText(QStringLiteral("Apply"));
	
	connect(d_tree_widget,&QTreeWidget::itemDoubleClicked,this,&TSettingsArtifactDialog::Item_Double_Clicked);
	connect(cancel_button,&QPushButton::clicked,this,&TSettingsArtifactDialog::reject);
	connect(d_apply_button,&QPushButton::clicked,this,&TSettingsArtifactDialog::accept);
}

TSettingsArtifactDialog::~TSettingsArtifactDialog(void)
{
}

void TSettingsArtifactDialog::Item_Double_Clicked(
	QTreeWidgetItem						*item,
	int									column)
{
	Qt::ItemFlags						flags(item->flags());
	
	if(column > 0)
	{
		item->setFlags(flags | Qt::ItemIsEditable);
	}
	else
	{
		item->setFlags(flags & (~Qt::ItemIsEditable));
	}
}

TSettingsWidget::TArtifactSettings TSettingsArtifactDialog::Settings(void) const
{
	TSettingsWidget::TArtifactSettings	settings;
	
	settings.sg_checkmaster_pln_x_start = d_sg_checkmaster_pln_start_x_item->text(1).toDouble();
	settings.sg_checkmaster_pln_x_end = d_sg_checkmaster_pln_end_x_item->text(1).toDouble();
	settings.sg_checkmaster_pln_y1 = d_sg_checkmaster_pln_start_y_item->text(1).toDouble();
	settings.sg_checkmaster_pln_y2 = d_sg_checkmaster_pln_end_y_item->text(1).toDouble();
	settings.sg_checkmaster_ln_x_start = d_sg_checkmaster_ln_start_x_item->text(1).toDouble();
	settings.sg_checkmaster_ln_x_end = d_sg_checkmaster_ln_end_x_item->text(1).toDouble();
	settings.sg_checkmaster_ln_z = d_sg_checkmaster_ln_z_item->text(1).toDouble();
	settings.sg_checkmaster_pnt_y = d_sg_checkmaster_pnt_y_item->text(1).toDouble();
	settings.sg_checkmaster_pnt_z = d_sg_checkmaster_pnt_z_item->text(1).toDouble();
	settings.sg_checkmaster_clear_z = d_sg_checkmaster_clear_z_item->text(1).toDouble();
	
	settings.sg_webber_clear_z = d_sg_webber_clear_z_item->text(1).toDouble();
	
	settings.sg_koba_pln_x_start = d_sg_koba_pln_start_x_item->text(1).toDouble();
	settings.sg_koba_pln_x_end = d_sg_koba_pln_end_x_item->text(1).toDouble();
	settings.sg_koba_pln_y1 = d_sg_koba_pln_start_y_item->text(1).toDouble();
	settings.sg_koba_pln_y2 = d_sg_koba_pln_end_y_item->text(1).toDouble();
	settings.sg_koba_ln_x_start = d_sg_koba_ln_start_x_item->text(1).toDouble();
	settings.sg_koba_ln_x_end = d_sg_koba_ln_end_x_item->text(1).toDouble();
	settings.sg_koba_ln_z = d_sg_koba_ln_z_item->text(1).toDouble();
	settings.sg_koba_pnt_y = d_sg_koba_pnt_y_item->text(1).toDouble();
	settings.sg_koba_pnt_z = d_sg_koba_pnt_z_item->text(1).toDouble();
	settings.sg_koba_clear_probe = d_sg_koba_clear_probe_item->text(1).toDouble();
	
	
	settings.gaugeblock_pln_y = d_gaugeblock_pnt_y_item->text(1).toDouble();
	settings.gaugeblock_pln_z = d_gaugeblock_pnt_z_item->text(1).toDouble();
	settings.gaugeblock_pln_sp = d_gaugeblock_pnt_spacing_item->text(1).toDouble();
	settings.gaugeblock_clear_z = d_gaugeblock_clear_z_item->text(1).toDouble();
	settings.ballbar_clear_distance = d_ballbar_b89_clear_distance_item->text(1).toDouble();
	settings.ballbar_avoidance_angle = d_ballbar_b89_avoidance_item->text(1).toDouble();
	settings.ballbar_10360_clear_distance = d_ballbar_10360_clear_distance_item->text(1).toDouble();
	settings.ballbar_10360_sphere_points = d_ballbar_10360_sphere_points_item->text(1).toDouble();
	settings.ringgauge_clear_z = d_ringgauge_clear_z_item->text(1).toDouble();
	settings.ringgauge_pln_offset = d_ringgauge_pln_offset_item->text(1).toDouble();
	settings.ringgauge_cir_z = d_ringgauge_cir_z_item->text(1).toDouble();
	settings.pingauge_clear_z = d_pingauge_clear_z_item->text(1).toDouble();
	settings.pingauge_pln_offset = d_pingauge_pln_offset_item->text(1).toDouble();
	settings.pingauge_cir_z = d_pingauge_cir_z_item->text(1).toDouble();
	
	settings.plane_sample_radius = d_plane_sample_radius_item->text(1).toDouble();

	settings.roll_clear_z = d_roll_clear_z_item->text(1).toDouble();
	settings.roll_sphere_points = d_roll_sphere_points_item->text(1).toInt();

	settings.calibration_sphere_clear_z = d_calibration_sphere_clear_z_item->text(1).toDouble();
	settings.calibration_sphere_points = d_calibration_sphere_points_item->text(1).toInt();

	return settings;
}

void TSettingsArtifactDialog::Reset(
	const TSettingsWidget::TArtifactSettings &settings)
{
	d_sg_checkmaster_pln_start_x_item->setText(1,QString("%1").arg(settings.sg_checkmaster_pln_x_start,0,'f',1));
	d_sg_checkmaster_pln_end_x_item->setText(1,QString("%1").arg(settings.sg_checkmaster_pln_x_end,0,'f',1));
	d_sg_checkmaster_pln_start_y_item->setText(1,QString("%1").arg(settings.sg_checkmaster_pln_y1,0,'f',1));
	d_sg_checkmaster_pln_end_y_item->setText(1,QString("%1").arg(settings.sg_checkmaster_pln_y2,0,'f',1));
	d_sg_checkmaster_ln_start_x_item->setText(1,QString("%1").arg(settings.sg_checkmaster_ln_x_start,0,'f',1));
	d_sg_checkmaster_ln_end_x_item->setText(1,QString("%1").arg(settings.sg_checkmaster_ln_x_end,0,'f',1));
	d_sg_checkmaster_ln_z_item->setText(1,QString("%1").arg(settings.sg_checkmaster_ln_z,0,'f',1));
	d_sg_checkmaster_pnt_y_item->setText(1,QString("%1").arg(settings.sg_checkmaster_pnt_y,0,'f',1));
	d_sg_checkmaster_pnt_z_item->setText(1,QString("%1").arg(settings.sg_checkmaster_pnt_z,0,'f',1));
	d_sg_checkmaster_clear_z_item->setText(1,QString("%1").arg(settings.sg_checkmaster_clear_z,0,'f',1));
	
	d_sg_webber_clear_z_item->setText(1,QString("%1").arg(settings.sg_webber_clear_z,0,'f',1));
	
	d_sg_koba_pln_start_x_item->setText(1,QString("%1").arg(settings.sg_koba_pln_x_start,0,'f',1));
	d_sg_koba_pln_end_x_item->setText(1,QString("%1").arg(settings.sg_koba_pln_x_end,0,'f',1));
	d_sg_koba_pln_start_y_item->setText(1,QString("%1").arg(settings.sg_koba_pln_y1,0,'f',1));
	d_sg_koba_pln_end_y_item->setText(1,QString("%1").arg(settings.sg_koba_pln_y2,0,'f',1));
	d_sg_koba_ln_start_x_item->setText(1,QString("%1").arg(settings.sg_koba_ln_x_start,0,'f',1));
	d_sg_koba_ln_end_x_item->setText(1,QString("%1").arg(settings.sg_koba_ln_x_end,0,'f',1));
	d_sg_koba_ln_z_item->setText(1,QString("%1").arg(settings.sg_koba_ln_z,0,'f',1));
	d_sg_koba_pnt_y_item->setText(1,QString("%1").arg(settings.sg_koba_pnt_y,0,'f',1));
	d_sg_koba_pnt_z_item->setText(1,QString("%1").arg(settings.sg_koba_pnt_z,0,'f',1));
	d_sg_koba_clear_probe_item->setText(1,QString("%1").arg(settings.sg_koba_clear_probe,0,'f',1));
	
	d_gaugeblock_pnt_y_item->setText(1,QString("%1").arg(settings.gaugeblock_pln_y,0,'f',1));
	d_gaugeblock_pnt_z_item->setText(1,QString("%1").arg(settings.gaugeblock_pln_z,0,'f',1));
	d_gaugeblock_pnt_spacing_item->setText(1,QString("%1").arg(settings.gaugeblock_pln_sp,0,'f',1));
	d_gaugeblock_clear_z_item->setText(1,QString("%1").arg(settings.gaugeblock_clear_z,0,'f',1));
	d_ballbar_b89_clear_distance_item->setText(1,QString("%1").arg(settings.ballbar_clear_distance,0,'f',1));
	d_ballbar_b89_avoidance_item->setText(1,QString("%1").arg(settings.ballbar_avoidance_angle,0,'f',1));
	d_ballbar_10360_clear_distance_item->setText(1,QString("%1").arg(settings.ballbar_10360_clear_distance,0,'f',1));
	d_ballbar_10360_sphere_points_item->setText(1,QString("%1").arg(settings.ballbar_10360_sphere_points));
	d_ringgauge_clear_z_item->setText(1,QString("%1").arg(settings.ringgauge_clear_z,0,'f',1));
	d_ringgauge_pln_offset_item->setText(1,QString("%1").arg(settings.ringgauge_pln_offset,0,'f',1));
	d_ringgauge_cir_z_item->setText(1,QString("%1").arg(settings.ringgauge_cir_z,0,'f',1));
	d_pingauge_clear_z_item->setText(1,QString("%1").arg(settings.pingauge_clear_z,0,'f',1));
	d_pingauge_pln_offset_item->setText(1,QString("%1").arg(settings.pingauge_pln_offset,0,'f',1));
	d_pingauge_cir_z_item->setText(1,QString("%1").arg(settings.pingauge_cir_z,0,'f',1));

	d_plane_sample_radius_item->setText(1,QString("%1").arg(settings.plane_sample_radius,0,'f',1));

	d_roll_clear_z_item->setText(1,QString("%1").arg(settings.roll_clear_z,0,'f',1));
	d_roll_sphere_points_item->setText(1,QString("%1").arg(settings.roll_sphere_points));

	d_calibration_sphere_clear_z_item->setText(1,QString("%1").arg(settings.calibration_sphere_clear_z,0,'f',1));
	d_calibration_sphere_points_item->setText(1,QString("%1").arg(settings.calibration_sphere_points));
}

