/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef SETTINGSARTIFACTDIALOGHEADERFILE
#define SETTINGSARTIFACTDIALOGHEADERFILE

#include <QDialog>

#include "settingswidget.h"

class QLineEdit;
class QPushButton;
class QTreeWidget;
class QTreeWidgetItem;

class TSettingsArtifactDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TSettingsArtifactDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TSettingsArtifactDialog(void);

// ACCESSORS
	TSettingsWidget::TArtifactSettings Settings(void) const;

// MANIPULATORS
	void Reset(const TSettingsWidget::TArtifactSettings &settings);

signals:

private slots:
	void Item_Double_Clicked(QTreeWidgetItem*,int);

private:
	QTreeWidget							*d_tree_widget;
	QTreeWidgetItem						*d_sg_checkmaster_pln_start_x_item;
	QTreeWidgetItem						*d_sg_checkmaster_pln_end_x_item;
	QTreeWidgetItem						*d_sg_checkmaster_pln_start_y_item;
	QTreeWidgetItem						*d_sg_checkmaster_pln_end_y_item;
	QTreeWidgetItem						*d_sg_checkmaster_ln_start_x_item;
	QTreeWidgetItem						*d_sg_checkmaster_ln_end_x_item;
	QTreeWidgetItem						*d_sg_checkmaster_ln_z_item;
	QTreeWidgetItem						*d_sg_checkmaster_pnt_y_item;
	QTreeWidgetItem						*d_sg_checkmaster_pnt_z_item;
	QTreeWidgetItem						*d_sg_checkmaster_clear_z_item;
	
	QTreeWidgetItem						*d_sg_webber_clear_z_item;

	QTreeWidgetItem						*d_sg_koba_pln_start_x_item;
	QTreeWidgetItem						*d_sg_koba_pln_end_x_item;
	QTreeWidgetItem						*d_sg_koba_pln_start_y_item;
	QTreeWidgetItem						*d_sg_koba_pln_end_y_item;
	QTreeWidgetItem						*d_sg_koba_ln_start_x_item;
	QTreeWidgetItem						*d_sg_koba_ln_end_x_item;
	QTreeWidgetItem						*d_sg_koba_ln_z_item;
	QTreeWidgetItem						*d_sg_koba_pnt_y_item;
	QTreeWidgetItem						*d_sg_koba_pnt_z_item;
	QTreeWidgetItem						*d_sg_koba_clear_probe_item;
	
	QTreeWidgetItem						*d_gaugeblock_pnt_y_item;
	QTreeWidgetItem						*d_gaugeblock_pnt_z_item;
	QTreeWidgetItem						*d_gaugeblock_pnt_spacing_item;
	QTreeWidgetItem						*d_gaugeblock_clear_z_item;
	QTreeWidgetItem						*d_ballbar_b89_clear_distance_item;
	QTreeWidgetItem						*d_ballbar_b89_avoidance_item;
	QTreeWidgetItem						*d_ballbar_10360_clear_distance_item;
	QTreeWidgetItem						*d_ballbar_10360_sphere_points_item;
	QTreeWidgetItem						*d_ringgauge_clear_z_item;
	QTreeWidgetItem						*d_ringgauge_pln_offset_item;
	QTreeWidgetItem						*d_ringgauge_cir_z_item;
	QTreeWidgetItem						*d_pingauge_clear_z_item;
	QTreeWidgetItem						*d_pingauge_pln_offset_item;
	QTreeWidgetItem						*d_pingauge_cir_z_item;

	QTreeWidgetItem						*d_plane_sample_radius_item;
	
	QTreeWidgetItem						*d_roll_clear_z_item;
	QTreeWidgetItem						*d_roll_sphere_points_item;
	QTreeWidgetItem						*d_calibration_sphere_clear_z_item;
	QTreeWidgetItem						*d_calibration_sphere_points_item;
	
	QPushButton							*d_apply_button;

// NOT IMPLEMENTED
	TSettingsArtifactDialog(const TSettingsArtifactDialog&);
	TSettingsArtifactDialog& operator=(const TSettingsArtifactDialog&);
};

#endif
