/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef SETTINGSMACHINEDIALOGHEADERFILE
#define SETTINGSMACHINEDIALOGHEADERFILE

#include <QDialog>

#include "controller.h"
#include "settingswidget.h"

class QLineEdit;
class QPushButton;
class QComboBox;

class TSettingsMachineDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TSettingsMachineDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TSettingsMachineDialog(void);

// ACCESSORS
	TSettingsWidget::TMachineSettings Settings(void) const;

// MANIPULATORS
	void Reset(const TSettingsWidget::TMachineSettings &settings,const TController::TControllerType controller_type);
	
	void Set_Temperature_Sensors_X(const QString &sensors);
	void Set_Temperature_Sensors_Y(const QString &sensors);
	void Set_Temperature_Sensors_Z(const QString &sensors);
	void Set_Temperature_Sensors_Part(const QString &sensors);

signals:
	void Request_Sensor_IDs(void);

private slots:
	void Options_Changed(void);
	void Thermal_Mode_Changed(void);
	void Move_Mode_Changed(void);
	

private:
	QComboBox							*d_thermal_compensation_mode_combo;
	QComboBox							*d_blended_move_mode_combo;
	QLineEdit							*d_acceleration_edit;
	QLineEdit							*d_approach_dist_edit;
	QLineEdit							*d_expansion_coeff_x_edit;
	QLineEdit							*d_expansion_coeff_y_edit;
	QLineEdit							*d_expansion_coeff_z_edit;
	QLineEdit							*d_move_speed_edit;
	QLineEdit							*d_sensors_part_edit;
	QLineEdit							*d_sensors_x_edit;
	QLineEdit							*d_sensors_y_edit;
	QLineEdit							*d_sensors_z_edit;
	QLineEdit							*d_touch_speed_edit;
	QPushButton							*d_get_sensor_ids_button;
	QPushButton							*d_apply_button;
	
	TSettingsWidget::TMachineSettings	d_settings;
	
	bool Validate_Sensor_List(QString &sensors);
	
	static QString Sensor_Data(const QString &text);

// NOT IMPLEMENTED
	TSettingsMachineDialog(const TSettingsMachineDialog&);
	TSettingsMachineDialog& operator=(const TSettingsMachineDialog&);
};

#endif
