/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////


#ifndef TEMPCOMPINFORMATIONDIALOGHEADERFILE
#define TEMPCOMPINFORMATIONDIALOGHEADERFILE

#include <QDialog>

class QLabel;

class TTempcompInformationDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TTempcompInformationDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TTempcompInformationDialog(void);

// ACCESSORS
	bool Update_Scale_Required(void) const {return d_update_scale;}

// MANIPULATORS
	void Set_Temperature_X(const double &d);
	void Set_Temperature_Y(const double &d);
	void Set_Temperature_Z(const double &d);
	void Set_Temperature_Part(const double &d);
	void Set_CTE_X(const double &d);
	void Set_CTE_Y(const double &d);
	void Set_CTE_Z(const double &d);
	void Set_CTE_Part(const double &d);
	void Set_Scale_X(const double &d);
	void Set_Scale_Y(const double &d);
	void Set_Scale_Z(const double &d);

signals:

private slots:

private:
	QLabel								*d_x_temperature_label;
	QLabel								*d_y_temperature_label;
	QLabel								*d_z_temperature_label;
	QLabel								*d_part_temperature_label;
	QLabel								*d_x_cte_label;
	QLabel								*d_y_cte_label;
	QLabel								*d_z_cte_label;
	QLabel								*d_part_cte_label;
	QLabel								*d_x_scale_label;
	QLabel								*d_y_scale_label;
	QLabel								*d_z_scale_label;
	
	bool								d_update_scale;

// NOT IMPLEMENTED
	TTempcompInformationDialog(const TTempcompInformationDialog&);
	TTempcompInformationDialog& operator=(const TTempcompInformationDialog&);
};

#endif
