/////////////////////////////////////////////////////////////////////
//
//            X   X           X
//           XXX XX         XX
//          XXXXXXXX      XXX
//         XX X XXXXXXXXXXX
//        XXXXX XXXXXXXXX
//       XXXXX XXXXXXXXXX
//            XXX XXX XXX
//           XXX XX   XX
//           X   X     X
//
//    Copyright (C) 2003-2026  Ron Jakl
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
/////////////////////////////////////////////////////////////////////

#ifndef TOOLBUILDERDIALOGHEADERFILE
#define TOOLBUILDERDIALOGHEADERFILE

#include <QDialog>
#include <QStringList>

#include "toolbuilderdata.h"

class QListWidget;
class QPushButton;
class QTreeWidget;
class QTreeWidgetItem;

class TToolBuilderDialog : public QDialog
{
Q_OBJECT

public:

// CREATORS
	TToolBuilderDialog(const QWidget *parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
	~TToolBuilderDialog(void);

// ACCESSORS
	TVector3 Fixed_Offset(void) const;
	TVector3 Rotational_Offset(void) const;
	QString Configuration_Name(void) const;

// MANIPULATORS
	void Reset(const QStringList &existing_names);

signals:

private slots:
	void Build_Selection_Changed(void);
	void Component_Selection_Changed(void);

private:
	
	QListWidget							*d_tool_components_list;
	QPushButton							*d_accept_button;
	QTreeWidget							*d_tool_build_tree;
	QTreeWidgetItem						*d_tool_build_top_item;
	
	TToolBuilderData					d_tool_builder_data;
	QStringList							d_existing_configuration_names;

// NOT IMPLEMENTED
	TToolBuilderDialog(const TToolBuilderDialog&);
	TToolBuilderDialog& operator=(const TToolBuilderDialog&);
};

#endif
